/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dreamlu.mica.core.function.CheckedCallable;
import net.dreamlu.mica.core.function.CheckedComparator;
import net.dreamlu.mica.core.function.CheckedConsumer;
import net.dreamlu.mica.core.function.CheckedFunction;
import net.dreamlu.mica.core.function.CheckedPredicate;
import net.dreamlu.mica.core.function.CheckedRunnable;
import net.dreamlu.mica.core.function.CheckedSupplier;
import net.dreamlu.mica.core.utils.Exceptions;

public class Unchecked {
    public static <T, R> Function<T, R> function(CheckedFunction<T, R> function) {
        Objects.requireNonNull(function);
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Throwable e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static <T> Consumer<T> consumer(CheckedConsumer<T> consumer) {
        Objects.requireNonNull(consumer);
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static <T> Supplier<T> supplier(CheckedSupplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static <T> Predicate<T> predicate(CheckedPredicate<T> predicate) {
        Objects.requireNonNull(predicate);
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Throwable e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static Runnable runnable(CheckedRunnable runnable) {
        Objects.requireNonNull(runnable);
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static <T> Callable<T> callable(CheckedCallable<T> callable) {
        Objects.requireNonNull(callable);
        return () -> {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static <T> Comparator<T> comparator(CheckedComparator<T> comparator) {
        Objects.requireNonNull(comparator);
        return (o1, o2) -> {
            try {
                return comparator.compare(o1, o2);
            }
            catch (Throwable e) {
                throw Exceptions.unchecked(e);
            }
        };
    }
}

