/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.ip2region.core;

import net.dreamlu.mica.ip2region.core.DbMakerConfigException;

public class DbConfig {
    private int totalHeaderSize;
    private int indexBlockSize;

    public DbConfig(int totalHeaderSize) throws DbMakerConfigException {
        if (totalHeaderSize % 8 != 0) {
            throw new DbMakerConfigException("totalHeaderSize must be times of 8");
        }
        this.totalHeaderSize = totalHeaderSize;
        this.indexBlockSize = 4096;
    }

    public DbConfig() throws DbMakerConfigException {
        this(8192);
    }

    public int getTotalHeaderSize() {
        return this.totalHeaderSize;
    }

    public DbConfig setTotalHeaderSize(int totalHeaderSize) {
        this.totalHeaderSize = totalHeaderSize;
        return this;
    }

    public int getIndexBlockSize() {
        return this.indexBlockSize;
    }

    public DbConfig setIndexBlockSize(int dataBlockSize) {
        this.indexBlockSize = dataBlockSize;
        return this;
    }
}

