/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.core;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;

public abstract class XssCleanDeserializerBase
extends JsonDeserializer<String> {
    public String deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        String text;
        String name = p.getCurrentName();
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            String text2 = p.getText();
            if (text2 == null) {
                return null;
            }
            return this.clean(name, text2);
        }
        JsonToken jsonToken = p.getCurrentToken();
        if (jsonToken.isScalarValue() && (text = p.getValueAsString()) != null) {
            return text;
        }
        throw MismatchedInputException.from((JsonParser)p, String.class, (String)("mica-xss: can't deserialize json name:" + name + " value of type java.lang.String from " + jsonToken));
    }

    public abstract String clean(String var1, String var2) throws IOException;
}

