/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.BigNumber;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.CommonBigNumberOperations;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.NarrowingOperations;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimalExtensionsKt;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.DecimalMode;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.RoundingMode;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.integer.BigInteger;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.integer.BigIntegerExtensionsKt;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.integer.ConfigurationKt;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.integer.Platform;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.integer.RuntimePlatform;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.integer.Sign;
import net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.integer.util.VariousUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\n\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\u0018\u0000 \u0087\u00012\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00050\u0004:\u0004\u0087\u0001\u0088\u0001B%\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010$\u001a\u00020\u0000H\u0016J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0016J\u001a\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000bJ*\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0(2\u0006\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020!H\u0016J\u0006\u0010.\u001a\u00020\u0000J\u0010\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020!H\u0002J\u000e\u00101\u001a\u0002022\u0006\u0010&\u001a\u00020\u0000J\u0011\u00103\u001a\u0002022\u0006\u0010&\u001a\u00020\u0005H\u0096\u0002J\u0018\u00104\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00002\u0006\u00105\u001a\u000206H\u0002J&\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u001d\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000bJ\u0006\u00108\u001a\u00020\u0000J\u0011\u00109\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010:\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0016J\u001a\u0010:\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000bJ\u001c\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000<2\u0006\u0010&\u001a\u00020\u0000H\u0016J\u001d\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000<2\u0006\u0010&\u001a\u00020\u0000H\u0086\u0004J(\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000<2\u0006\u0010&\u001a\u00020\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010-\u001a\u00020!H\u0016J\u0013\u0010@\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\u0010\u0010A\u001a\u00020B2\u0006\u0010-\u001a\u00020!H\u0016J\u0006\u0010C\u001a\u00020\u0000J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00000EH\u0016J\b\u0010F\u001a\u00020\u0000H\u0016J\u0010\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0000H\u0002J\b\u0010I\u001a\u000202H\u0016J\u0006\u0010J\u001a\u00020\u0000J\u0010\u0010K\u001a\u0002022\u0006\u0010-\u001a\u00020!H\u0016J\u001c\u0010L\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002J\u0006\u0010M\u001a\u00020!J\b\u0010N\u001a\u00020!H\u0016J\u0010\u0010O\u001a\u0002022\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020\t2\u0006\u0010-\u001a\u00020!H\u0016J\u0011\u0010S\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u000202J\u000e\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\tJ\u0010\u0010V\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0016J\u001a\u0010V\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000bJ\b\u0010W\u001a\u00020\u0000H\u0016J\u0010\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020YH\u0002J\b\u0010[\u001a\u00020\tH\u0016J\u0018\u0010\\\u001a\u00020Y2\u0006\u0010Z\u001a\u00020Y2\u0006\u0010]\u001a\u000202H\u0002J\u0018\u0010^\u001a\u00020Y2\u0006\u0010Z\u001a\u00020Y2\u0006\u0010]\u001a\u000202H\u0002J\u0011\u0010_\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010`\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u000202H\u0016J\u0010\u0010`\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0011\u0010a\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\u001c\u0010a\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010b\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0016J\u0006\u0010c\u001a\u00020\u0000J\u0010\u0010d\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0000H\u0002J\u0010\u0010e\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010f\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0016\u0010h\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ\b\u0010i\u001a\u000200H\u0016J\u0010\u0010j\u001a\u00020k2\u0006\u0010-\u001a\u00020!H\u0016J\b\u0010l\u001a\u000202H\u0016J\u0010\u0010m\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0016J\u001a\u0010m\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000bJ\u0011\u0010n\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010o\u001a\u00020\u0007J\u0006\u0010p\u001a\u00020YJ\b\u0010q\u001a\u00020YH\u0016J\u0010\u0010q\u001a\u00020Y2\u0006\u0010r\u001a\u000202H\u0016J\u0006\u0010s\u001a\u00020YJ \u0010t\u001a\u00020u2\u0006\u0010-\u001a\u00020!H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bv\u0010wJ \u0010x\u001a\u00020y2\u0006\u0010-\u001a\u00020!H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bz\u0010{J \u0010|\u001a\u00020}2\u0006\u0010-\u001a\u00020!H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b~\u0010\u007fJ\n\u0010\u0080\u0001\u001a\u00020\u0000H\u0096\u0002J$\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u0010-\u001a\u00020!H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\b\u0083\u0001\u0010\u0084\u0001J\u0017\u0010n\u001a\u00020Y*\u00020\t2\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001H\u0086\u0002R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0089\u0001"}, d2={"Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/BigDecimal;", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/BigNumber;", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/CommonBigNumberOperations;", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/NarrowingOperations;", "", "", "_significand", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/integer/BigInteger;", "_exponent", "", "_decimalMode", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/DecimalMode;", "(Lcom/ionspin/kotlin/bignum/integer/BigInteger;JLcom/ionspin/kotlin/bignum/decimal/DecimalMode;)V", "decimalMode", "getDecimalMode", "()Lcom/ionspin/kotlin/bignum/decimal/DecimalMode;", "exponent", "getExponent", "()J", "precision", "getPrecision", "precisionLimit", "getPrecisionLimit", "roundingMode", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/RoundingMode;", "getRoundingMode", "()Lcom/ionspin/kotlin/bignum/decimal/RoundingMode;", "scale", "getScale", "significand", "getSignificand", "()Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "usingScale", "", "getUsingScale", "()Z", "abs", "add", "other", "bringSignificandToSameExponent", "Lkotlin/Triple;", "first", "second", "byteValue", "", "exactRequired", "ceil", "checkWholeness", "", "compare", "", "compareTo", "computeMode", "op", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/BigDecimal$ScaleOps;", "copy", "dec", "div", "divide", "divideAndRemainder", "Lkotlin/Pair;", "divrem", "doubleValue", "", "equals", "floatValue", "", "floor", "getCreator", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/BigNumber$Creator;", "getInstance", "getRidOfRadix", "bigDecimal", "hashCode", "inc", "intValue", "integerDiv", "isWholeNumber", "isZero", "javascriptNumberComparison", "number", "", "longValue", "minus", "moveDecimalPoint", "places", "multiply", "negate", "noExponentStringtoScientificNotation", "", "input", "numberOfDecimalDigits", "placeADotInString", "position", "placeADotInStringExpanded", "plus", "pow", "rem", "remainder", "removeScale", "removeTrailingZeroes", "roundSignificand", "roundToDigitPosition", "digitPosition", "roundToDigitPositionAfterDecimalPoint", "secureOverwrite", "shortValue", "", "signum", "subtract", "times", "toBigInteger", "toPlainString", "toString", "base", "toStringExpanded", "ubyteValue", "Lkotlin/UByte;", "ubyteValue-Wa3L5BU", "(Z)B", "uintValue", "Lkotlin/UInt;", "uintValue-OGnWXxg", "(Z)I", "ulongValue", "Lkotlin/ULong;", "ulongValue-I7RO_PI", "(Z)J", "unaryMinus", "ushortValue", "Lkotlin/UShort;", "ushortValue-BwKQO78", "(Z)S", "char", "", "Companion", "ScaleOps", "bignum"})
public final class BigDecimal
implements BigNumber<BigDecimal>,
CommonBigNumberOperations<BigDecimal>,
NarrowingOperations<BigDecimal>,
Comparable<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long precision;
    @NotNull
    private final BigInteger significand;
    private final long exponent;
    @Nullable
    private final DecimalMode decimalMode;
    private final long precisionLimit;
    @NotNull
    private final RoundingMode roundingMode;
    private final long scale;
    private final boolean usingScale;
    @NotNull
    private static final BigDecimal ZERO = new BigDecimal(BigInteger.Companion.getZERO(), 0L, null, 6, null);
    @NotNull
    private static final BigDecimal ONE = new BigDecimal(BigInteger.Companion.getONE(), 0L, null, 6, null);
    @NotNull
    private static final BigDecimal TWO = new BigDecimal(BigInteger.Companion.getTWO(), 0L, null, 6, null);
    @NotNull
    private static final BigDecimal TEN = new BigDecimal(BigInteger.Companion.getTEN(), 1L, null, 4, null);
    private static boolean useToStringExpanded;
    @NotNull
    private static final double[] double10pow;
    @NotNull
    private static final BigDecimal maximumDouble;
    @NotNull
    private static final BigDecimal leastSignificantDouble;
    @NotNull
    private static final float[] float10pow;
    @NotNull
    private static final BigDecimal maximumFloat;
    @NotNull
    private static final BigDecimal leastSignificantFloat;

    private BigDecimal(BigInteger _significand, long _exponent, DecimalMode _decimalMode) {
        if (_decimalMode != null && _decimalMode.getUsingScale()) {
            BigDecimal wrk = BigDecimal.Companion.applyScale(_significand, _exponent, _decimalMode);
            if (!wrk.isZero()) {
                long newPrecision;
                this.significand = wrk.significand;
                this.exponent = wrk.exponent;
                this.precision = newPrecision = this.significand.numberOfDecimalDigits();
                this.decimalMode = DecimalMode.copy$default(_decimalMode, newPrecision, null, 0L, 6, null);
            } else {
                this.significand = wrk.significand;
                this.exponent = wrk.exponent * (_decimalMode.getDecimalPrecision() + _decimalMode.getScale());
                this.precision = _decimalMode.getDecimalPrecision() + _decimalMode.getScale();
                this.decimalMode = DecimalMode.copy$default(_decimalMode, this.precision, null, 0L, 6, null);
            }
        } else {
            this.significand = _significand;
            this.precision = _significand.numberOfDecimalDigits();
            this.exponent = _exponent;
            this.decimalMode = _decimalMode;
        }
        DecimalMode decimalMode = this.decimalMode;
        this.precisionLimit = decimalMode != null ? decimalMode.getDecimalPrecision() : 0L;
        Object object = this.decimalMode;
        if (object == null || (object = object.getRoundingMode()) == null) {
            object = RoundingMode.NONE;
        }
        this.roundingMode = object;
        DecimalMode decimalMode2 = this.decimalMode;
        this.scale = decimalMode2 != null ? decimalMode2.getScale() : -1L;
        this.usingScale = this.scale >= 0L;
    }

    /* synthetic */ BigDecimal(BigInteger bigInteger, long l, DecimalMode decimalMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            decimalMode = null;
        }
        this(bigInteger, l, decimalMode);
    }

    public final long getPrecision() {
        return this.precision;
    }

    @NotNull
    public final BigInteger getSignificand() {
        return this.significand;
    }

    public final long getExponent() {
        return this.exponent;
    }

    @Nullable
    public final DecimalMode getDecimalMode() {
        return this.decimalMode;
    }

    public final long getPrecisionLimit() {
        return this.precisionLimit;
    }

    @NotNull
    public final RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public final long getScale() {
        return this.scale;
    }

    public final boolean getUsingScale() {
        return this.usingScale;
    }

    @NotNull
    public final BigDecimal scale(long scale) {
        if (scale < 0L) {
            throw new ArithmeticException("Negative Scale is unsupported.");
        }
        DecimalMode mode = this.decimalMode == null ? (scale == -1L ? DecimalMode.Companion.getDEFAULT() : new DecimalMode(0L, RoundingMode.ROUND_HALF_AWAY_FROM_ZERO, scale)) : new DecimalMode(this.decimalMode.getDecimalPrecision() - this.decimalMode.getScale(), this.decimalMode.getRoundingMode(), scale);
        return new BigDecimal(this.significand, this.exponent, mode);
    }

    @NotNull
    public final BigDecimal removeScale() {
        DecimalMode decimalMode = this.decimalMode;
        long l = decimalMode != null ? decimalMode.getDecimalPrecision() : 0L;
        Object object = this.decimalMode;
        if (object == null || (object = object.getRoundingMode()) == null) {
            object = RoundingMode.NONE;
        }
        return new BigDecimal(this.significand, this.exponent, new DecimalMode(l, (RoundingMode)((Object)object), -1L));
    }

    @Override
    @NotNull
    public BigNumber.Creator<BigDecimal> getCreator() {
        return Companion;
    }

    @Override
    @NotNull
    public BigDecimal getInstance() {
        return this;
    }

    @Override
    @NotNull
    public BigDecimal add(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other, this.computeMode(other, ScaleOps.Max));
    }

    @NotNull
    public final BigDecimal add(@NotNull BigDecimal other, @Nullable DecimalMode decimalMode) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        if (Intrinsics.areEqual((Object)this, (Object)ZERO)) {
            return BigDecimal.Companion.roundOrDont(other.significand, other.exponent, resolvedDecimalMode);
        }
        if (Intrinsics.areEqual((Object)other, (Object)ZERO)) {
            return BigDecimal.Companion.roundOrDont(this.significand, this.exponent, resolvedDecimalMode);
        }
        Triple<BigInteger, BigInteger, Long> triple = this.bringSignificandToSameExponent(this, other);
        BigInteger first = (BigInteger)triple.component1();
        BigInteger second2 = (BigInteger)triple.component2();
        long firstNumOfDigits = first.numberOfDecimalDigits();
        long secondNumOfDigits = second2.numberOfDecimalDigits();
        BigInteger newSignificand = (BigInteger)first.plus((BigNumber)second2);
        long newSignificandNumOfDigit = newSignificand.numberOfDecimalDigits();
        long largerOperand = firstNumOfDigits > secondNumOfDigits ? firstNumOfDigits : secondNumOfDigits;
        long carryDetected = newSignificandNumOfDigit - largerOperand;
        long newExponent = Math.max(this.exponent, other.exponent) + carryDetected;
        return resolvedDecimalMode.getUsingScale() ? BigDecimal.Companion.roundOrDont(newSignificand, newExponent, DecimalMode.copy$default(resolvedDecimalMode, newSignificandNumOfDigit, null, 0L, 6, null)) : BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    public static /* synthetic */ BigDecimal add$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.add(bigDecimal2, decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal subtract(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.subtract(other, this.computeMode(other, ScaleOps.Max));
    }

    @NotNull
    public final BigDecimal subtract(@NotNull BigDecimal other, @Nullable DecimalMode decimalMode) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        if (Intrinsics.areEqual((Object)this, (Object)ZERO)) {
            return BigDecimal.Companion.roundOrDont(other.significand.negate(), other.exponent, resolvedDecimalMode);
        }
        if (Intrinsics.areEqual((Object)other, (Object)ZERO)) {
            return BigDecimal.Companion.roundOrDont(this.significand, this.exponent, resolvedDecimalMode);
        }
        Triple<BigInteger, BigInteger, Long> triple = this.bringSignificandToSameExponent(this, other);
        BigInteger first = (BigInteger)triple.component1();
        BigInteger second2 = (BigInteger)triple.component2();
        long firstNumOfDigits = first.numberOfDecimalDigits();
        long secondNumOfDigits = second2.numberOfDecimalDigits();
        BigInteger newSignificand = (BigInteger)first.minus((BigNumber)second2);
        long newSignificandNumOfDigit = newSignificand.numberOfDecimalDigits();
        long largerOperand = firstNumOfDigits > secondNumOfDigits ? firstNumOfDigits : secondNumOfDigits;
        long borrowDetected = newSignificandNumOfDigit - largerOperand;
        long newExponent = Math.max(this.exponent, other.exponent) + borrowDetected;
        if (this.usingScale) {
            return BigDecimal.Companion.roundOrDont(newSignificand, newExponent, DecimalMode.copy$default(resolvedDecimalMode, newSignificandNumOfDigit, null, 0L, 6, null));
        }
        return BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    public static /* synthetic */ BigDecimal subtract$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.subtract(bigDecimal2, decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal multiply(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.multiply(other, this.computeMode(other, ScaleOps.Max));
    }

    @NotNull
    public final BigDecimal multiply(@NotNull BigDecimal other, @Nullable DecimalMode decimalMode) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        long firstNumOfDigits = this.significand.numberOfDecimalDigits();
        long secondNumOfDigits = other.significand.numberOfDecimalDigits();
        BigInteger newSignificand = (BigInteger)this.significand.times((BigNumber)other.significand);
        long newSignificandNumOfDigit = newSignificand.numberOfDecimalDigits();
        long moveExponent = newSignificandNumOfDigit - (firstNumOfDigits + secondNumOfDigits);
        long newExponent = this.exponent + other.exponent + moveExponent + 1L;
        return resolvedDecimalMode.getUsingScale() ? BigDecimal.Companion.roundOrDont(newSignificand, newExponent, DecimalMode.copy$default(resolvedDecimalMode, newSignificandNumOfDigit, null, 0L, 6, null)) : BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    public static /* synthetic */ BigDecimal multiply$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.multiply(bigDecimal2, decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal divide(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.divide(other, this.computeMode(other, ScaleOps.Max));
    }

    @NotNull
    public final BigDecimal divide(@NotNull BigDecimal other, @Nullable DecimalMode decimalMode) {
        long exponentModifier2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        if (resolvedDecimalMode.isPrecisionUnlimited() && !resolvedDecimalMode.getUsingScale()) {
            long newExponent = this.exponent - other.exponent;
            long power = other.precision * (long)2 + (long)6;
            BigInteger thisPrepared = (BigInteger)this.significand.times((BigNumber)BigInteger.Companion.getTEN().pow(power));
            BigInteger.QuotientAndRemainder divRem = thisPrepared.divrem(other.significand);
            BigInteger result2 = divRem.getQuotient();
            long expectedDiff = other.precision - 1L;
            long exponentModifier2 = expectedDiff + (result2.numberOfDecimalDigits() - thisPrepared.numberOfDecimalDigits());
            if (!Intrinsics.areEqual((Object)divRem.getRemainder(), (Object)BigInteger.Companion.getZERO())) {
                throw new ArithmeticException("Non-terminating result of division operation (i.e. 1/3 = 0.3333... library needs to know when to stop and how to round up at that point). Specify decimalPrecision inside your decimal mode.");
            }
            return new BigDecimal(result2, newExponent + exponentModifier2, resolvedDecimalMode);
        }
        long newExponent = this.exponent - other.exponent - 1L;
        long desiredPrecision = resolvedDecimalMode.getDecimalPrecision();
        long power = desiredPrecision - this.precision + other.precision;
        BigInteger thisPrepared = power > 0L ? (BigInteger)this.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(power)) : (power < 0L ? (BigInteger)this.significand.div((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(Math.abs(power))) : this.significand);
        BigInteger.QuotientAndRemainder divRem = thisPrepared.divrem(other.significand);
        BigInteger result3 = divRem.getQuotient();
        if (Intrinsics.areEqual((Object)result3, (Object)BigInteger.Companion.getZERO())) {
            exponentModifier2 = newExponent;
            newExponent = exponentModifier2 + -1L;
        }
        exponentModifier2 = result3.numberOfDecimalDigits() - resolvedDecimalMode.getDecimalPrecision();
        return this.usingScale ? new BigDecimal(BigDecimal.Companion.roundDiscarded(result3, divRem.getRemainder(), resolvedDecimalMode), newExponent + exponentModifier2, DecimalMode.copy$default(resolvedDecimalMode, result3.numberOfDecimalDigits(), null, 0L, 6, null)) : new BigDecimal(BigDecimal.Companion.roundDiscarded(result3, divRem.getRemainder(), resolvedDecimalMode), newExponent + exponentModifier2, resolvedDecimalMode);
    }

    public static /* synthetic */ BigDecimal divide$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.divide(bigDecimal2, decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal remainder(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (BigDecimal)this.divideAndRemainder(other).getSecond();
    }

    @Override
    @NotNull
    public Pair<BigDecimal, BigDecimal> divideAndRemainder(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.exponent < 0L) {
            return new Pair((Object)ZERO, (Object)this);
        }
        if (other.abs().compareTo(this.abs()) > 0) {
            return new Pair((Object)ZERO, (Object)this);
        }
        DecimalMode decimalMode = this.decimalMode;
        if (decimalMode == null || (decimalMode = DecimalMode.copy$default(decimalMode, this.exponent + 1L, null, 0L, 6, null)) == null) {
            decimalMode = new DecimalMode(this.exponent + 1L, RoundingMode.FLOOR, 0L, 4, null);
        }
        DecimalMode resolvedRoundingMode = decimalMode;
        BigDecimal quotient = this.divide(other, resolvedRoundingMode);
        BigDecimal quotientInfinitePrecision = BigDecimal.copy$default(quotient, null, 0L, DecimalMode.Companion.getDEFAULT(), 3, null);
        BigDecimal remainder = this.minus(quotientInfinitePrecision.times(other));
        return new Pair((Object)quotient, (Object)remainder);
    }

    @Override
    public boolean isZero() {
        return this.significand.isZero();
    }

    @NotNull
    public final BigDecimal copy(@NotNull BigInteger significand, long exponent, @Nullable DecimalMode decimalMode) {
        Intrinsics.checkNotNullParameter((Object)significand, (String)"significand");
        return new BigDecimal(significand, exponent, decimalMode);
    }

    public static /* synthetic */ BigDecimal copy$default(BigDecimal bigDecimal, BigInteger bigInteger, long l, DecimalMode decimalMode, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger = bigDecimal.significand;
        }
        if ((n & 2) != 0) {
            l = bigDecimal.exponent;
        }
        if ((n & 4) != 0) {
            decimalMode = bigDecimal.decimalMode;
        }
        return bigDecimal.copy(bigInteger, l, decimalMode);
    }

    @NotNull
    public final BigDecimal moveDecimalPoint(int places) {
        if (places == 0) {
            return this;
        }
        return BigDecimal.copy$default(this, null, this.exponent + (long)places, null, 5, null);
    }

    @NotNull
    public final BigDecimal moveDecimalPoint(long places) {
        if (places == 0L) {
            return this;
        }
        return BigDecimal.copy$default(this, null, this.exponent + places, null, 5, null);
    }

    @Override
    @NotNull
    public BigDecimal pow(int exponent) {
        return this.pow((long)exponent);
    }

    @NotNull
    public final BigDecimal floor() {
        if (this.exponent < 0L) {
            BigDecimal bigDecimal;
            switch (WhenMappings.$EnumSwitchMapping$0[this.significand.getSign$bignum().ordinal()]) {
                case 1: {
                    bigDecimal = ZERO;
                    break;
                }
                case 2: {
                    bigDecimal = ONE.negate();
                    break;
                }
                case 3: {
                    bigDecimal = ZERO;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bigDecimal;
        }
        return this.roundSignificand(new DecimalMode(this.exponent + 1L, RoundingMode.FLOOR, 0L, 4, null));
    }

    @NotNull
    public final BigDecimal ceil() {
        if (this.isZero()) {
            return ZERO;
        }
        if (this.exponent < 0L) {
            BigDecimal bigDecimal;
            switch (WhenMappings.$EnumSwitchMapping$0[this.significand.getSign$bignum().ordinal()]) {
                case 1: {
                    bigDecimal = ONE;
                    break;
                }
                case 2: {
                    bigDecimal = ZERO;
                    break;
                }
                case 3: {
                    bigDecimal = ZERO;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bigDecimal;
        }
        return this.roundSignificand(new DecimalMode(this.exponent + 1L, RoundingMode.CEILING, 0L, 4, null));
    }

    @NotNull
    public final BigInteger toBigInteger() {
        if (this.exponent < 0L) {
            return BigInteger.Companion.getZERO();
        }
        long precisionExponentDiff = this.exponent - this.precision;
        return precisionExponentDiff > 0L ? (BigInteger)this.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(precisionExponentDiff + 1L)) : (precisionExponentDiff < 0L ? (BigInteger)this.significand.div((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(Math.abs(precisionExponentDiff) - 1L)) : (BigInteger)this.significand.times(10));
    }

    @Override
    public long numberOfDecimalDigits() {
        long l;
        long l2 = this.precision;
        long l3 = this.exponent;
        boolean bl = 1L <= l3 ? l3 < l2 : false;
        if (bl) {
            l = this.precision;
        } else if (this.exponent > 0L && this.exponent > this.precision) {
            l = this.exponent + 1L;
        } else if (this.exponent > 0L && this.exponent == this.precision) {
            l = this.precision + 1L;
        } else if (this.exponent < 0L) {
            l = Math.abs(this.exponent) + this.precision;
        } else if (this.exponent == 0L) {
            l = this.removeTrailingZeroes((BigDecimal)this).precision;
        } else {
            throw new RuntimeException("Invalid case when getting number of decimal digits");
        }
        long numberOfDigits = l;
        return numberOfDigits;
    }

    private final BigDecimal removeTrailingZeroes(BigDecimal bigDecimal) {
        if (Intrinsics.areEqual((Object)bigDecimal, (Object)ZERO)) {
            return this;
        }
        BigInteger significand = bigDecimal.significand;
        BigInteger.QuotientAndRemainder divisionResult = new BigInteger.QuotientAndRemainder(bigDecimal.significand, BigInteger.Companion.getZERO());
        do {
            if (!Intrinsics.areEqual((Object)(divisionResult = divisionResult.getQuotient().divrem(BigInteger.Companion.getTEN())).getRemainder(), (Object)BigInteger.Companion.getZERO())) continue;
            significand = divisionResult.getQuotient();
        } while (Intrinsics.areEqual((Object)divisionResult.getRemainder(), (Object)BigInteger.Companion.getZERO()));
        return new BigDecimal(significand, bigDecimal.exponent, null, 4, null);
    }

    @Override
    @NotNull
    public String toString(int base) {
        if (base != 10) {
            throw new RuntimeException("BigDecimal in base other than 10 is not supported yet");
        }
        return this.toString();
    }

    private final BigDecimal integerDiv(BigDecimal other, DecimalMode decimalMode) {
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        long newExponent = this.exponent - other.exponent;
        BigInteger newSignificand = (BigInteger)this.significand.div((BigNumber)other.significand);
        return BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    static /* synthetic */ BigDecimal integerDiv$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.integerDiv(bigDecimal2, decimalMode);
    }

    private final BigDecimal rem(BigDecimal other, DecimalMode decimalMode) {
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        long newExponent = this.exponent - other.exponent;
        BigInteger newSignificand = (BigInteger)this.significand.rem((BigNumber)other.significand);
        return BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    static /* synthetic */ BigDecimal rem$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.rem(bigDecimal2, decimalMode);
    }

    private final Pair<BigDecimal, BigDecimal> divrem(BigDecimal other, DecimalMode decimalMode) {
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        long newExponent = Math.max(this.exponent, other.exponent);
        BigInteger newSignificand = (BigInteger)this.significand.div((BigNumber)other.significand);
        BigInteger newRemainderSignificand = (BigInteger)this.significand.rem((BigNumber)other.significand);
        return new Pair((Object)BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode), (Object)BigDecimal.Companion.roundOrDont(newRemainderSignificand, newExponent, resolvedDecimalMode));
    }

    static /* synthetic */ Pair divrem$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.divrem(bigDecimal2, decimalMode);
    }

    @NotNull
    public final Pair<BigDecimal, BigDecimal> divrem(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.divideAndRemainder(other);
    }

    private final DecimalMode computeMode(BigDecimal other, ScaleOps op) {
        DecimalMode decimalMode;
        block6: {
            long l;
            RoundingMode roundingMode;
            long l2;
            block8: {
                block7: {
                    block5: {
                        if (this.decimalMode != null && !this.decimalMode.isPrecisionUnlimited() && other.decimalMode != null && !other.decimalMode.isPrecisionUnlimited()) break block5;
                        decimalMode = DecimalMode.Companion.getDEFAULT();
                        break block6;
                    }
                    l2 = Math.max(this.decimalMode.getDecimalPrecision(), other.decimalMode.getDecimalPrecision());
                    roundingMode = this.decimalMode.getRoundingMode();
                    if (!this.decimalMode.getUsingScale() || !other.decimalMode.getUsingScale()) break block7;
                    switch (WhenMappings.$EnumSwitchMapping$1[op.ordinal()]) {
                        case 1: {
                            l = Math.max(this.decimalMode.getScale(), other.decimalMode.getScale());
                            break block8;
                        }
                        case 2: {
                            l = Math.min(this.decimalMode.getScale(), other.decimalMode.getScale());
                            break block8;
                        }
                        case 3: {
                            l = this.decimalMode.getScale() + other.decimalMode.getScale();
                            break block8;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                l = -1L;
            }
            decimalMode = new DecimalMode(l2, roundingMode, l);
        }
        return decimalMode;
    }

    @Override
    @NotNull
    public BigDecimal plus(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other, this.computeMode(other, ScaleOps.Max));
    }

    @Override
    @NotNull
    public BigDecimal minus(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.subtract(other, this.computeMode(other, ScaleOps.Max));
    }

    @Override
    @NotNull
    public BigDecimal times(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.multiply(other, this.computeMode(other, ScaleOps.Max));
    }

    @Override
    @NotNull
    public BigDecimal div(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.divide(other, this.computeMode(other, ScaleOps.Max));
    }

    @Override
    @NotNull
    public BigDecimal rem(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.rem(other, null);
    }

    @Override
    @NotNull
    public BigDecimal unaryMinus() {
        return new BigDecimal(this.significand.negate(), this.exponent, this.decimalMode);
    }

    @Override
    public void secureOverwrite() {
        this.significand.secureOverwrite();
    }

    @NotNull
    public final BigDecimal inc() {
        return (BigDecimal)this.plus(1);
    }

    @NotNull
    public final BigDecimal dec() {
        return (BigDecimal)this.minus(1);
    }

    @Override
    @NotNull
    public BigDecimal abs() {
        return new BigDecimal(this.significand.abs(), this.exponent, this.decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal negate() {
        return new BigDecimal(this.significand.negate(), this.exponent, this.decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal pow(long exponent) {
        BigDecimal bigDecimal;
        if (Intrinsics.areEqual((Object)this, (Object)ZERO) && exponent < 0L) {
            throw new ArithmeticException("Negative exponentiation of zero is not defined.");
        }
        BigDecimal result2 = this;
        if (exponent > 0L) {
            long l = exponent - 1L;
            for (long i = 0L; i < l; ++i) {
                result2 = result2.times(this);
            }
            bigDecimal = result2;
        } else if (exponent < 0L) {
            if (exponent == Long.MIN_VALUE) {
                long i = 0L;
                if (i <= Long.MAX_VALUE) {
                    while (true) {
                        result2 = result2.div(this);
                        if (i == Long.MAX_VALUE) break;
                        ++i;
                    }
                }
                result2 = result2.div(this);
            } else {
                long i = 0L;
                long l = Math.abs(exponent);
                if (i <= l) {
                    while (true) {
                        result2 = result2.div(this);
                        if (i == l) break;
                        ++i;
                    }
                }
            }
            bigDecimal = result2;
        } else {
            bigDecimal = ONE;
        }
        return bigDecimal;
    }

    @Override
    public int signum() {
        return this.significand.signum();
    }

    @Override
    public int intValue(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().intValue(exactRequired);
    }

    @Override
    public long longValue(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().longValue(exactRequired);
    }

    @Override
    public byte byteValue(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().byteValue(exactRequired);
    }

    @Override
    public short shortValue(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().shortValue(exactRequired);
    }

    @Override
    public int uintValue-OGnWXxg(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().uintValue-OGnWXxg(exactRequired);
    }

    @Override
    public long ulongValue-I7RO_PI(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().ulongValue-I7RO_PI(exactRequired);
    }

    @Override
    public byte ubyteValue-Wa3L5BU(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().ubyteValue-Wa3L5BU(exactRequired);
    }

    @Override
    public short ushortValue-BwKQO78(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().ushortValue-BwKQO78(exactRequired);
    }

    public final boolean isWholeNumber() {
        Pair<BigDecimal, BigDecimal> res = this.abs().divrem(ONE);
        boolean isWholeNumber = ((BigDecimal)res.getSecond()).isZero();
        return isWholeNumber;
    }

    private final void checkWholeness(boolean exactRequired) {
        if (exactRequired && !this.isWholeNumber()) {
            throw new ArithmeticException("Cannot convert to int and provide exact value");
        }
    }

    @Override
    public float floatValue(boolean exactRequired) {
        if (exactRequired) {
            int totalBits;
            int n;
            boolean exactPossible = true;
            if (this.exponent < -45L || this.exponent > 38L) {
                exactPossible = false;
            }
            if (this.precision - this.exponent - 1L > 0L) {
                int bitSum;
                BigInteger integerPart = this.exponent >= 0L ? (BigInteger)this.significand.div((BigNumber)BigInteger.Companion.getTEN().pow(this.precision - this.exponent - 1L)) : BigInteger.Companion.getZERO();
                int integerPartBitLength = ConfigurationKt.getChosenArithmetic().bitLength-QwZRm1k(integerPart.getMagnitude-Y2RjT0g$bignum());
                BigInteger fractionPart = this.significand.divrem(BigInteger.Companion.getTEN().pow(this.precision - this.exponent - 1L)).getRemainder();
                BigDecimal fractionConvertTemp = new BigDecimal(fractionPart, -1L, null, 4, null);
                List bitList = new ArrayList();
                for (int counter = 0; !Intrinsics.areEqual((Object)fractionConvertTemp, (Object)ZERO) && counter <= 24; ++counter) {
                    BigDecimal multiplied = (BigDecimal)fractionConvertTemp.times(2);
                    int bit = multiplied.compareTo(ONE) >= 0 ? 1 : 0;
                    bitList.add(bit);
                    fractionConvertTemp = bit == 1 ? (BigDecimal)multiplied.divrem(TEN).getSecond() : multiplied;
                }
                n = bitSum = integerPartBitLength + bitList.size();
            } else {
                int trailingZeroBits = ConfigurationKt.getChosenArithmetic().trailingZeroBits-QwZRm1k(this.significand.getMagnitude-Y2RjT0g$bignum());
                int bitSum = ConfigurationKt.getChosenArithmetic().bitLength-QwZRm1k(this.significand.getMagnitude-Y2RjT0g$bignum());
                n = totalBits = bitSum - trailingZeroBits;
            }
            if (totalBits > 24) {
                exactPossible = false;
            }
            if (!exactPossible) {
                throw new ArithmeticException("Value cannot be narrowed to float");
            }
        }
        long divExponent = this.precision - 1L - this.exponent;
        long f = this.significand.longValue(exactRequired);
        return divExponent >= 0L && divExponent < (long)float10pow.length ? (float)f / float10pow[(int)divExponent] : Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue(boolean exactRequired) {
        if (exactRequired) {
            int totalBits;
            int n;
            boolean exactPossible = true;
            if (this.exponent < -324L || this.exponent > 308L) {
                exactPossible = false;
            }
            if (this.precision - this.exponent - 1L > 0L) {
                int bitSum;
                BigInteger integerPart = this.exponent >= 0L ? (BigInteger)this.significand.div((BigNumber)BigInteger.Companion.getTEN().pow(this.precision - this.exponent - 1L)) : BigInteger.Companion.getZERO();
                int integerPartBitLength = ConfigurationKt.getChosenArithmetic().bitLength-QwZRm1k(integerPart.getMagnitude-Y2RjT0g$bignum());
                BigInteger fractionPart = this.significand.divrem(BigInteger.Companion.getTEN().pow(this.precision - this.exponent - 1L)).getRemainder();
                BigDecimal fractionConvertTemp = new BigDecimal(fractionPart, -1L, null, 4, null);
                List bitList = new ArrayList();
                for (int counter = 0; !Intrinsics.areEqual((Object)fractionConvertTemp, (Object)ZERO) && counter <= 53; ++counter) {
                    BigDecimal multiplied = (BigDecimal)fractionConvertTemp.times(2);
                    int bit = multiplied.compareTo(ONE) >= 0 ? 1 : 0;
                    bitList.add(bit);
                    fractionConvertTemp = bit == 1 ? (BigDecimal)multiplied.divrem(TEN).getSecond() : multiplied;
                }
                n = bitSum = integerPartBitLength + bitList.size();
            } else {
                int trailingZeroBits = ConfigurationKt.getChosenArithmetic().trailingZeroBits-QwZRm1k(this.significand.getMagnitude-Y2RjT0g$bignum());
                int bitSum = ConfigurationKt.getChosenArithmetic().bitLength-QwZRm1k(this.significand.getMagnitude-Y2RjT0g$bignum());
                n = totalBits = bitSum - trailingZeroBits;
            }
            if (totalBits > 53) {
                exactPossible = false;
            }
            if (!exactPossible) {
                throw new ArithmeticException("Value cannot be narrowed to float");
            }
        }
        long divExponent = this.precision - 1L - this.exponent;
        long l = this.significand.longValue(exactRequired);
        if (this.significand.compareTo((Object)Long.MAX_VALUE) > 0 || this.significand.compareTo((Object)Long.MIN_VALUE) < 0) {
            return Double.parseDouble(this.toString());
        }
        return (long)((double)l) == l && divExponent >= 0L && divExponent < (long)double10pow.length ? (double)l / double10pow[(int)divExponent] : Double.parseDouble(this.toString());
    }

    @NotNull
    public final BigDecimal roundSignificand(@Nullable DecimalMode decimalMode) {
        if (decimalMode == null) {
            return this;
        }
        return BigDecimal.Companion.roundSignificand(this.significand, this.exponent, decimalMode);
    }

    @NotNull
    public final BigDecimal roundToDigitPosition(long digitPosition, @NotNull RoundingMode roundingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode), (String)"roundingMode");
        if (digitPosition == 0L) {
            throw new ArithmeticException("Rounding to 0 position is not supported");
        }
        BigDecimal rounded = this.exponent >= 0L ? this.roundSignificand(new DecimalMode(digitPosition, roundingMode, 0L, 4, null)) : (BigDecimal)((BigDecimal)this.plus(this.signum())).roundSignificand(new DecimalMode(digitPosition, roundingMode, 0L, 4, null)).minus(this.signum());
        return this.decimalMode == null ? new BigDecimal(rounded.significand, rounded.exponent, null, 4, null) : new BigDecimal(rounded.significand, rounded.exponent, this.decimalMode);
    }

    public static /* synthetic */ BigDecimal roundToDigitPosition$default(BigDecimal bigDecimal, long l, RoundingMode roundingMode, int n, Object object) {
        if ((n & 2) != 0) {
            roundingMode = bigDecimal.roundingMode;
        }
        return bigDecimal.roundToDigitPosition(l, roundingMode);
    }

    @NotNull
    public final BigDecimal roundToDigitPositionAfterDecimalPoint(long digitPosition, @NotNull RoundingMode roundingMode) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode), (String)"roundingMode");
        if (digitPosition < 0L) {
            throw new ArithmeticException("This method doesn't support negative digit position");
        }
        if (this.exponent >= 0L) {
            bigDecimal = this.roundToDigitPosition(this.exponent + digitPosition + 1L, roundingMode);
        } else if (this.exponent < 0L) {
            bigDecimal = this.roundToDigitPosition(digitPosition + 1L, roundingMode);
        } else {
            throw new RuntimeException("Unexpected state");
        }
        BigDecimal rounded = bigDecimal;
        return this.decimalMode == null ? new BigDecimal(rounded.significand, rounded.exponent, null, 4, null) : new BigDecimal(rounded.significand, rounded.exponent, this.decimalMode);
    }

    private final BigDecimal getRidOfRadix(BigDecimal bigDecimal) {
        long precision = bigDecimal.significand.numberOfDecimalDigits();
        long newExponent = bigDecimal.exponent - precision + 1L;
        return new BigDecimal(bigDecimal.significand, newExponent, null, 4, null);
    }

    private final Triple<BigInteger, BigInteger, Long> bringSignificandToSameExponent(BigDecimal first, BigDecimal second2) {
        long moveFirstBy;
        BigDecimal firstPrepared = this.getRidOfRadix(first);
        BigDecimal secondPrepared = this.getRidOfRadix(second2);
        long firstPreparedExponent = firstPrepared.exponent;
        long secondPreparedExponent = secondPrepared.exponent;
        if (first.exponent > second2.exponent) {
            moveFirstBy = firstPreparedExponent - secondPreparedExponent;
            if (moveFirstBy >= 0L) {
                BigInteger movedFirst = (BigInteger)firstPrepared.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(moveFirstBy));
                return new Triple((Object)movedFirst, (Object)second2.significand, (Object)secondPreparedExponent);
            }
        } else {
            if (first.exponent < second2.exponent) {
                Triple triple;
                long moveSecondBy = secondPreparedExponent - firstPreparedExponent;
                if (moveSecondBy >= 0L) {
                    BigInteger movedSecond = (BigInteger)secondPrepared.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(moveSecondBy));
                    triple = new Triple((Object)first.significand, (Object)movedSecond, (Object)firstPreparedExponent);
                } else {
                    BigInteger movedFirst = (BigInteger)firstPrepared.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(moveSecondBy * (long)-1));
                    triple = new Triple((Object)movedFirst, (Object)second2.significand, (Object)firstPreparedExponent);
                }
                return triple;
            }
            if (first.exponent == second2.exponent) {
                Triple triple;
                long delta = firstPreparedExponent - secondPreparedExponent;
                if (delta > 0L) {
                    BigInteger movedFirst = (BigInteger)first.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(delta));
                    triple = new Triple((Object)movedFirst, (Object)second2.significand, (Object)firstPreparedExponent);
                } else if (delta < 0L) {
                    BigInteger movedSecond = (BigInteger)second2.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(delta * (long)-1));
                    triple = new Triple((Object)first.significand, (Object)movedSecond, (Object)firstPreparedExponent);
                } else if (Intrinsics.compare((long)delta, (long)0L) == 0) {
                    triple = new Triple((Object)first.significand, (Object)second2.significand, (Object)firstPreparedExponent);
                } else {
                    throw new RuntimeException("Invalid delta: " + delta);
                }
                return triple;
            }
            throw new RuntimeException("Invalid comparison state BigInteger: " + first.exponent + ", " + second2.exponent);
        }
        BigInteger movedSecond = (BigInteger)secondPrepared.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(moveFirstBy * (long)-1));
        return new Triple((Object)first.significand, (Object)movedSecond, (Object)firstPreparedExponent);
    }

    public final int compare(@NotNull BigDecimal other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.exponent == other.exponent && this.precision == other.precision) {
            n = this.significand.compare(other.significand);
        } else {
            Triple<BigInteger, BigInteger, Long> triple = this.bringSignificandToSameExponent(this, other);
            BigInteger preparedFirst = (BigInteger)triple.component1();
            BigInteger preparedSecond = (BigInteger)triple.component2();
            n = preparedFirst.compare(preparedSecond);
        }
        return n;
    }

    @Override
    public int compareTo(@NotNull Object other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof Number && RuntimePlatform.INSTANCE.currentPlatform() == Platform.JS) {
            return this.javascriptNumberComparison((Number)other);
        }
        Object object = other;
        if (object instanceof BigDecimal) {
            n = this.compare((BigDecimal)other);
        } else if (object instanceof Long) {
            n = this.compare(Companion.fromLong(((Number)other).longValue()));
        } else if (object instanceof Integer) {
            n = this.compare(Companion.fromInt(((Number)other).intValue()));
        } else if (object instanceof Short) {
            n = this.compare(Companion.fromShort(((Number)other).shortValue()));
        } else if (object instanceof Byte) {
            n = this.compare(Companion.fromByte(((Number)other).byteValue()));
        } else if (object instanceof Double) {
            n = this.compare(net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromDouble$default(Companion, ((Number)other).doubleValue(), null, 2, null));
        } else if (object instanceof Float) {
            n = this.compare(net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromFloat$default(Companion, ((Number)other).floatValue(), null, 2, null));
        } else {
            throw new RuntimeException("Invalid comparison type for BigDecimal: " + Reflection.getOrCreateKotlinClass(other.getClass()).getSimpleName());
        }
        return n;
    }

    private final int javascriptNumberComparison(Number number) {
        double d = number.doubleValue();
        return d > 9.223372036854776E18 ? this.compare(Companion.parseString(String.valueOf(d))) : (d % 1.0 == 0.0 ? this.compare(Companion.fromLong(number.longValue())) : this.compare(BigDecimalExtensionsKt.toBigDecimal$default(number.doubleValue(), null, null, 3, null)));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        Object object = other;
        int comparison = object instanceof BigDecimal ? this.compare((BigDecimal)other) : (object instanceof Long ? this.compare(Companion.fromLong(((Number)other).longValue())) : (object instanceof Integer ? this.compare(Companion.fromInt(((Number)other).intValue())) : (object instanceof Short ? this.compare(Companion.fromShort(((Number)other).shortValue())) : (object instanceof Byte ? this.compare(Companion.fromByte(((Number)other).byteValue())) : (object instanceof Double ? this.compare(net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromDouble$default(Companion, ((Number)other).doubleValue(), null, 2, null)) : (object instanceof Float ? this.compare(net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromFloat$default(Companion, ((Number)other).floatValue(), null, 2, null)) : -1))))));
        return comparison == 0;
    }

    public int hashCode() {
        if (Intrinsics.areEqual((Object)this, (Object)ZERO)) {
            return 0;
        }
        return this.removeTrailingZeroes((BigDecimal)this).significand.hashCode() + Long.hashCode(this.exponent);
    }

    @Override
    @NotNull
    public String toString() {
        String string;
        String string2;
        int modifier;
        String significandString;
        block8: {
            if (useToStringExpanded) {
                return this.toStringExpanded();
            }
            significandString = this.significand.toString(10);
            modifier = this.significand.compareTo((Object)0) < 0 ? 2 : 1;
            String $this$dropLastWhile$iv = this.significand.toString();
            boolean $i$f$dropLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$dropLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '0') continue;
                String string3 = $this$dropLastWhile$iv;
                int n = 0;
                int n2 = index$iv + 1;
                String string4 = string3.substring(n, n2);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block8;
            }
            string2 = "";
        }
        String expand = string2.length() <= 1 ? "0" : "";
        if (this.exponent > 0L) {
            string = this.placeADotInString(significandString, significandString.length() - modifier) + expand + "E+" + this.exponent;
        } else if (this.exponent < 0L) {
            string = this.placeADotInString(significandString, significandString.length() - modifier) + expand + 'E' + this.exponent;
        } else if (this.exponent == 0L) {
            string = this.placeADotInString(significandString, significandString.length() - modifier) + expand;
        } else {
            throw new RuntimeException("Invalid state, please report a bug (Integer compareTo invalid)");
        }
        return string;
    }

    @NotNull
    public final String toPlainString() {
        long missingZeroCount;
        String[] stringArray;
        List split2;
        String expandedString = this.toStringExpanded();
        String finalString = this.usingScale && this.scale > 0L ? ((split2 = StringsKt.split$default((CharSequence)expandedString, (String[])(stringArray = new String[]{"."}), (boolean)false, (int)0, (int)6, null)).size() == 1 ? expandedString + '.' + VariousUtilKt.times('0', this.scale) : ((missingZeroCount = this.scale - (long)((String)split2.get(1)).length()) > 0L ? expandedString + VariousUtilKt.times('0', missingZeroCount) : expandedString)) : expandedString;
        return finalString;
    }

    @NotNull
    public final String toStringExpanded() {
        String string;
        if (Intrinsics.areEqual((Object)this, (Object)ZERO)) {
            return "0";
        }
        long digits = this.significand.numberOfDecimalDigits();
        if (this.exponent > Integer.MAX_VALUE) {
            throw new RuntimeException("Invalid toStringExpanded request (exponent > Int.MAX_VALUE)");
        }
        String significandString = this.significand.toStringWithoutSign$bignum(10);
        String sign = this.significand.getSign$bignum() == Sign.NEGATIVE ? "-" : "";
        if (this.exponent > 0L) {
            long diffBigInt = this.exponent - digits + 1L;
            if (diffBigInt > 0L) {
                String expandZeros = this.times(diffBigInt, '0');
                string = significandString + expandZeros;
            } else {
                string = this.placeADotInStringExpanded(significandString, significandString.length() - (int)this.exponent - 1);
            }
        } else if (this.exponent < 0L) {
            int diffInt = Math.abs((int)this.exponent);
            if (diffInt > 0) {
                String expandZeros = this.times(Math.abs(this.exponent), '0');
                string = this.placeADotInStringExpanded(expandZeros + significandString, diffInt + significandString.length() - 1);
            } else {
                string = this.placeADotInStringExpanded(significandString, significandString.length() - 1);
            }
        } else if (this.exponent == 0L) {
            if (digits == 1L) {
                return sign + significandString;
            }
            string = this.placeADotInStringExpanded(significandString, significandString.length() - 1);
        } else {
            throw new RuntimeException("Invalid state, please report a bug (Integer compareTo invalid)");
        }
        String adjusted = string;
        return sign + adjusted;
    }

    private final String noExponentStringtoScientificNotation(String input) {
        return this.placeADotInString(input, input.length() - 1) + "E+" + (input.length() - 1);
    }

    private final String placeADotInStringExpanded(String input, int position) {
        String string;
        String prefix;
        block1: {
            prefix = StringsKt.substring((String)input, (IntRange)RangesKt.until((int)0, (int)(input.length() - position)));
            String $this$dropLastWhile$iv = StringsKt.substring((String)input, (IntRange)RangesKt.until((int)(input.length() - position), (int)input.length()));
            boolean $i$f$dropLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$dropLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '0') continue;
                String string2 = $this$dropLastWhile$iv;
                int n = 0;
                int n2 = index$iv + 1;
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block1;
            }
            string = "";
        }
        String suffix = string;
        return ((CharSequence)suffix).length() > 0 ? prefix + '.' + suffix : prefix;
    }

    private final String placeADotInString(String input, int position) {
        String string;
        block1: {
            String prepared;
            String prefix = StringsKt.substring((String)input, (IntRange)RangesKt.until((int)0, (int)(input.length() - position)));
            String suffix = StringsKt.substring((String)input, (IntRange)RangesKt.until((int)(input.length() - position), (int)input.length()));
            String $this$dropLastWhile$iv = prepared = prefix + '.' + suffix;
            boolean $i$f$dropLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$dropLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '0') continue;
                String string2 = $this$dropLastWhile$iv;
                int n = 0;
                int n2 = index$iv + 1;
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block1;
            }
            string = "";
        }
        return string;
    }

    @NotNull
    public final String times(long $this$times, char c) {
        if ($this$times < 0L) {
            throw new RuntimeException("Char cannot be multiplied with negative number");
        }
        long counter = $this$times;
        StringBuilder stringBuilder = new StringBuilder();
        while (counter > 0L) {
            stringBuilder.append(c);
            long l = counter;
            counter = l + -1L;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    @Override
    @NotNull
    public BigDecimal rem(int n) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, n);
    }

    @Override
    @NotNull
    public BigDecimal rem(long l) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, l);
    }

    @Override
    @NotNull
    public BigDecimal rem(short s) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, s);
    }

    @Override
    @NotNull
    public BigDecimal rem(byte by) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, by);
    }

    @Override
    @NotNull
    public BigDecimal plus(int n) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, n);
    }

    @Override
    @NotNull
    public BigDecimal plus(long l) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, l);
    }

    @Override
    @NotNull
    public BigDecimal plus(short s) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, s);
    }

    @Override
    @NotNull
    public BigDecimal plus(byte by) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, by);
    }

    @Override
    @NotNull
    public BigDecimal minus(int n) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, n);
    }

    @Override
    @NotNull
    public BigDecimal minus(long l) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, l);
    }

    @Override
    @NotNull
    public BigDecimal minus(short s) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, s);
    }

    @Override
    @NotNull
    public BigDecimal minus(byte by) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, by);
    }

    @Override
    @NotNull
    public BigDecimal times(int n) {
        return CommonBigNumberOperations.DefaultImpls.times(this, n);
    }

    @Override
    @NotNull
    public BigDecimal times(long l) {
        return CommonBigNumberOperations.DefaultImpls.times(this, l);
    }

    @Override
    @NotNull
    public BigDecimal times(short s) {
        return CommonBigNumberOperations.DefaultImpls.times(this, s);
    }

    @Override
    @NotNull
    public BigDecimal times(byte by) {
        return CommonBigNumberOperations.DefaultImpls.times(this, by);
    }

    @Override
    @NotNull
    public BigDecimal div(int n) {
        return CommonBigNumberOperations.DefaultImpls.div(this, n);
    }

    @Override
    @NotNull
    public BigDecimal div(long l) {
        return CommonBigNumberOperations.DefaultImpls.div(this, l);
    }

    @Override
    @NotNull
    public BigDecimal div(short s) {
        return CommonBigNumberOperations.DefaultImpls.div(this, s);
    }

    @Override
    @NotNull
    public BigDecimal div(byte by) {
        return CommonBigNumberOperations.DefaultImpls.div(this, by);
    }

    @Override
    public boolean isNegative() {
        return BigNumber.DefaultImpls.isNegative(this);
    }

    @Override
    public boolean isPositive() {
        return BigNumber.DefaultImpls.isPositive(this);
    }

    public /* synthetic */ BigDecimal(BigInteger _significand, long _exponent, DecimalMode _decimalMode, DefaultConstructorMarker $constructor_marker) {
        this(_significand, _exponent, _decimalMode);
    }

    static {
        Object[] objectArray = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        double10pow = objectArray;
        maximumDouble = net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromDouble$default(Companion, Double.MAX_VALUE, null, 2, null);
        leastSignificantDouble = net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromDouble$default(Companion, Double.MIN_VALUE, null, 2, null);
        objectArray = new float[11];
        objectArray[0] = 1.0f;
        objectArray[1] = 10.0f;
        objectArray[2] = 100.0f;
        objectArray[3] = 1000.0f;
        objectArray[4] = 10000.0f;
        objectArray[5] = 100000.0f;
        objectArray[6] = 1000000.0f;
        objectArray[7] = 1.0E7f;
        objectArray[8] = 1.0E8f;
        objectArray[9] = 1.0E9f;
        objectArray[10] = 1.0E10f;
        float10pow = (float[])objectArray;
        maximumFloat = net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromFloat$default(Companion, Float.MAX_VALUE, null, 2, null);
        leastSignificantFloat = net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromFloat$default(Companion, Float.MIN_VALUE, null, 2, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001pB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0002J\u001a\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u00022\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u001dH\u0016J\u001a\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u001d2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u0010)\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0016J\u001a\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u0010-\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u0010.\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u000207H\u0016J\u001a\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u00108\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u00109\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020\u001fH\u0016J\u001a\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u0010<\u001a\u00020\u00022\u0006\u0010;\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u0010=\u001a\u00020\u00022\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020@H\u0016J\u001a\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020@2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u0010A\u001a\u00020\u00022\u0006\u0010?\u001a\u00020@2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u0010B\u001a\u00020\u00022\u0006\u0010?\u001a\u00020@2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001d\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020EH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bF\u0010GJ'\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bH\u0010IJ\u001d\u0010J\u001a\u00020\u00022\u0006\u0010K\u001a\u00020LH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bM\u0010NJ'\u0010J\u001a\u00020\u00022\u0006\u0010K\u001a\u00020L2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bO\u0010PJ\u001d\u0010Q\u001a\u00020\u00022\u0006\u0010R\u001a\u00020SH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bT\u0010UJ'\u0010Q\u001a\u00020\u00022\u0006\u0010R\u001a\u00020S2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bV\u0010WJ\u001d\u0010X\u001a\u00020\u00022\u0006\u0010Y\u001a\u00020ZH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b[\u0010\\J'\u0010X\u001a\u00020\u00022\u0006\u0010Y\u001a\u00020Z2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b]\u0010^J\u001e\u0010_\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010`\u001a\u00020\u00022\u0006\u0010a\u001a\u00020bJ\u0018\u0010`\u001a\u00020\u00022\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u000207H\u0016J\u001a\u0010d\u001a\u00020\u00022\u0006\u0010e\u001a\u00020b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J&\u0010f\u001a\u00020!2\b\u0010g\u001a\u0004\u0018\u00010!2\b\u0010h\u001a\u0004\u0018\u00010!2\b\u0010i\u001a\u0004\u0018\u00010!H\u0002J \u0010j\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0002J \u0010k\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J \u0010l\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010m\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u0010n\u001a\u00020\u0016H\u0016J\u0018\u0010o\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\u0006\u0010n\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006q"}, d2={"Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/BigDecimal$Companion;", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/BigNumber$Creator;", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/BigDecimal;", "()V", "ONE", "getONE", "()Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "TEN", "getTEN", "TWO", "getTWO", "ZERO", "getZERO", "double10pow", "", "float10pow", "", "leastSignificantDouble", "leastSignificantFloat", "maximumDouble", "maximumFloat", "useToStringExpanded", "", "getUseToStringExpanded", "()Z", "setUseToStringExpanded", "(Z)V", "applyScale", "significand", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/integer/BigInteger;", "exponent", "", "decimalMode", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/DecimalMode;", "determineDecider", "Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/BigDecimal$Companion$SignificantDecider;", "discarded", "fromBigDecimal", "bigDecimal", "fromBigInteger", "bigInteger", "fromBigIntegerWithExponent", "fromByte", "byte", "", "fromByteAsSignificand", "fromByteWithExponent", "fromDouble", "double", "", "fromFloat", "float", "", "fromInt", "int", "", "fromIntAsSignificand", "fromIntWithExponent", "fromLong", "long", "fromLongAsSignificand", "fromLongWithExponent", "fromShort", "short", "", "fromShortAsSignificand", "fromShortWithExponent", "fromUByte", "uByte", "Lkotlin/UByte;", "fromUByte-7apg3OU", "(B)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUByte-0ky7B_Q", "(BLcom/ionspin/kotlin/bignum/decimal/DecimalMode;)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUInt", "uInt", "Lkotlin/UInt;", "fromUInt-WZ4Q5Ns", "(I)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUInt-qim9Vi0", "(ILcom/ionspin/kotlin/bignum/decimal/DecimalMode;)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromULong", "uLong", "Lkotlin/ULong;", "fromULong-VKZWuLQ", "(J)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromULong-4PLdz1A", "(JLcom/ionspin/kotlin/bignum/decimal/DecimalMode;)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUShort", "uShort", "Lkotlin/UShort;", "fromUShort-xj2QHRw", "(S)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUShort-vckuEUM", "(SLcom/ionspin/kotlin/bignum/decimal/DecimalMode;)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "handleZeroRounding", "parseString", "string", "", "base", "parseStringWithMode", "floatingPointString", "resolveDecimalMode", "firstDecimalMode", "secondDecimalMode", "suppliedDecimalMode", "roundDiscarded", "roundOrDont", "roundSignificand", "tryFromDouble", "exactRequired", "tryFromFloat", "SignificantDecider", "bignum"})
    public static final class Companion
    implements BigNumber.Creator<BigDecimal> {
        private Companion() {
        }

        @Override
        @NotNull
        public BigDecimal getZERO() {
            return ZERO;
        }

        @Override
        @NotNull
        public BigDecimal getONE() {
            return ONE;
        }

        @Override
        @NotNull
        public BigDecimal getTWO() {
            return TWO;
        }

        @Override
        @NotNull
        public BigDecimal getTEN() {
            return TEN;
        }

        public final boolean getUseToStringExpanded() {
            return useToStringExpanded;
        }

        public final void setUseToStringExpanded(boolean bl) {
            useToStringExpanded = bl;
        }

        private final BigDecimal roundOrDont(BigInteger significand, long exponent, DecimalMode decimalMode) {
            return decimalMode.isPrecisionUnlimited() ? new BigDecimal(significand, exponent, null, 4, null) : this.roundSignificand(significand, exponent, decimalMode);
        }

        private final SignificantDecider determineDecider(BigInteger discarded) {
            SignificantDecider significantDecider;
            BigInteger scale = BigInteger.Companion.getTEN().pow(discarded.numberOfDecimalDigits() - 1L);
            BigInteger.QuotientAndRemainder divrem = discarded.divrem(scale);
            int significant = divrem.getQuotient().abs().intValue(true);
            BigInteger rest = divrem.getRemainder().abs();
            if (significant == 5) {
                significantDecider = Intrinsics.areEqual((Object)rest, (Object)BigInteger.Companion.getZERO()) ? SignificantDecider.FIVE : SignificantDecider.MORE_THAN_FIVE;
            } else if (significant > 5) {
                significantDecider = SignificantDecider.MORE_THAN_FIVE;
            } else if (significant < 5) {
                significantDecider = SignificantDecider.LESS_THAN_FIVE;
            } else {
                throw new RuntimeException("Couldn't determine decider");
            }
            return significantDecider;
        }

        private final BigInteger roundDiscarded(BigInteger significand, BigInteger discarded, DecimalMode decimalMode) {
            Sign sign;
            Pair pair;
            long toDiscard = significand.numberOfDecimalDigits() - decimalMode.getDecimalPrecision();
            if (toDiscard > 0L) {
                BigInteger.QuotientAndRemainder additionallyDiscarded = significand.divrem(BigInteger.Companion.getTEN().pow(toDiscard));
                pair = new Pair((Object)additionallyDiscarded.getQuotient(), (Object)additionallyDiscarded.getRemainder());
            } else {
                pair = new Pair((Object)significand, (Object)discarded);
            }
            Pair pair2 = pair;
            BigInteger result2 = (BigInteger)pair2.component1();
            BigInteger remainder = (BigInteger)pair2.component2();
            Sign sign2 = sign = Intrinsics.areEqual((Object)significand, (Object)BigInteger.Companion.getZERO()) ? discarded.getSign$bignum() : significand.getSign$bignum();
            if (remainder.isZero()) {
                return result2;
            }
            SignificantDecider decider = this.determineDecider(remainder);
            switch (WhenMappings.$EnumSwitchMapping$1[decimalMode.getRoundingMode().ordinal()]) {
                case 1: {
                    if (sign == Sign.POSITIVE) {
                        BigInteger bigInteger = result2;
                        result2 = bigInteger.inc();
                        break;
                    }
                    BigInteger bigInteger = result2;
                    result2 = bigInteger.dec();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (sign != Sign.POSITIVE) break;
                    BigInteger bigInteger = result2;
                    result2 = bigInteger.inc();
                    break;
                }
                case 4: {
                    if (sign == Sign.POSITIVE) break;
                    BigInteger bigInteger = result2;
                    result2 = bigInteger.dec();
                    break;
                }
                case 5: {
                    switch (WhenMappings.$EnumSwitchMapping$0[sign.ordinal()]) {
                        case 1: {
                            if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                            BigInteger bigInteger = result2;
                            result2 = bigInteger.inc();
                            break;
                        }
                        case 2: {
                            if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                            BigInteger bigInteger = result2;
                            result2 = bigInteger.dec();
                        }
                    }
                    break;
                }
                case 6: {
                    switch (WhenMappings.$EnumSwitchMapping$0[sign.ordinal()]) {
                        case 1: {
                            if (decider != SignificantDecider.MORE_THAN_FIVE) break;
                            BigInteger bigInteger = result2;
                            result2 = bigInteger.inc();
                            break;
                        }
                        case 2: {
                            if (decider != SignificantDecider.MORE_THAN_FIVE) break;
                            BigInteger bigInteger = result2;
                            result2 = bigInteger.dec();
                        }
                    }
                    break;
                }
                case 7: {
                    switch (WhenMappings.$EnumSwitchMapping$0[sign.ordinal()]) {
                        case 1: {
                            if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                            BigInteger bigInteger = result2;
                            result2 = bigInteger.inc();
                            break;
                        }
                        case 2: {
                            if (decider != SignificantDecider.MORE_THAN_FIVE) break;
                            BigInteger bigInteger = result2;
                            result2 = bigInteger.dec();
                        }
                    }
                    break;
                }
                case 8: {
                    switch (WhenMappings.$EnumSwitchMapping$0[sign.ordinal()]) {
                        case 1: {
                            if (decider != SignificantDecider.MORE_THAN_FIVE) break;
                            BigInteger bigInteger = result2;
                            result2 = bigInteger.inc();
                            break;
                        }
                        case 2: {
                            if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                            BigInteger bigInteger = result2;
                            result2 = bigInteger.dec();
                        }
                    }
                    break;
                }
                case 9: {
                    BigInteger bigInteger;
                    if (decider == SignificantDecider.FIVE) {
                        if (Intrinsics.areEqual((Object)significand.rem(2), (Object)BigInteger.Companion.getONE())) {
                            switch (WhenMappings.$EnumSwitchMapping$0[sign.ordinal()]) {
                                case 1: {
                                    if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                                    BigInteger bigInteger2 = result2;
                                    result2 = bigInteger2.inc();
                                    break;
                                }
                                case 2: {
                                    if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                                    BigInteger bigInteger3 = result2;
                                    result2 = bigInteger3.dec();
                                }
                            }
                            break;
                        }
                        switch (WhenMappings.$EnumSwitchMapping$0[sign.ordinal()]) {
                            case 1: {
                                if (decider != SignificantDecider.MORE_THAN_FIVE) break;
                                BigInteger bigInteger4 = result2;
                                result2 = bigInteger4.inc();
                                break;
                            }
                            case 2: {
                                if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                                BigInteger bigInteger5 = result2;
                                result2 = bigInteger5.dec();
                            }
                        }
                        break;
                    }
                    if (decider != SignificantDecider.MORE_THAN_FIVE) break;
                    if (sign == Sign.POSITIVE) {
                        bigInteger = result2;
                        result2 = bigInteger.inc();
                    }
                    if (sign != Sign.NEGATIVE) break;
                    bigInteger = result2;
                    result2 = bigInteger.dec();
                    break;
                }
                case 10: {
                    BigInteger bigInteger;
                    if (decider == SignificantDecider.FIVE) {
                        if (Intrinsics.areEqual((Object)significand.rem(2), (Object)BigInteger.Companion.getZERO())) {
                            switch (WhenMappings.$EnumSwitchMapping$0[sign.ordinal()]) {
                                case 1: {
                                    if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                                    BigInteger bigInteger6 = result2;
                                    result2 = bigInteger6.inc();
                                    break;
                                }
                                case 2: {
                                    if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                                    BigInteger bigInteger7 = result2;
                                    result2 = bigInteger7.dec();
                                }
                            }
                            break;
                        }
                        switch (WhenMappings.$EnumSwitchMapping$0[sign.ordinal()]) {
                            case 1: {
                                if (decider != SignificantDecider.MORE_THAN_FIVE) break;
                                BigInteger bigInteger8 = result2;
                                result2 = bigInteger8.inc();
                                break;
                            }
                            case 2: {
                                if (decider == SignificantDecider.LESS_THAN_FIVE) break;
                                BigInteger bigInteger9 = result2;
                                result2 = bigInteger9.dec();
                            }
                        }
                        break;
                    }
                    if (decider != SignificantDecider.MORE_THAN_FIVE) break;
                    if (sign == Sign.POSITIVE) {
                        bigInteger = result2;
                        result2 = bigInteger.inc();
                    }
                    if (sign != Sign.NEGATIVE) break;
                    bigInteger = result2;
                    result2 = bigInteger.dec();
                    break;
                }
                case 11: {
                    throw new ArithmeticException("Non-terminating result of division operation. Specify decimalPrecision");
                }
            }
            return result2;
        }

        @NotNull
        public final BigDecimal handleZeroRounding(@NotNull BigInteger significand, long exponent, @NotNull DecimalMode decimalMode) {
            BigDecimal bigDecimal;
            Intrinsics.checkNotNullParameter((Object)significand, (String)"significand");
            Intrinsics.checkNotNullParameter((Object)decimalMode, (String)"decimalMode");
            if (significand.getSign$bignum() == Sign.POSITIVE) {
                switch (WhenMappings.$EnumSwitchMapping$1[decimalMode.getRoundingMode().ordinal()]) {
                    case 1: 
                    case 3: {
                        BigInteger increasedSignificand = significand.inc();
                        long exponentModifier = increasedSignificand.numberOfDecimalDigits() - significand.numberOfDecimalDigits();
                        bigDecimal = new BigDecimal(increasedSignificand, exponent + exponentModifier, decimalMode, null);
                        break;
                    }
                    default: {
                        bigDecimal = new BigDecimal(significand, exponent, decimalMode, null);
                        break;
                    }
                }
            } else if (significand.getSign$bignum() == Sign.NEGATIVE) {
                switch (WhenMappings.$EnumSwitchMapping$1[decimalMode.getRoundingMode().ordinal()]) {
                    case 1: 
                    case 4: {
                        BigInteger increasedSignificand = significand.dec();
                        long exponentModifier = increasedSignificand.numberOfDecimalDigits() - significand.numberOfDecimalDigits();
                        bigDecimal = new BigDecimal(increasedSignificand, exponent + exponentModifier, decimalMode, null);
                        break;
                    }
                    default: {
                        bigDecimal = new BigDecimal(significand, exponent, decimalMode, null);
                        break;
                    }
                }
            } else {
                bigDecimal = new BigDecimal(significand, exponent, decimalMode, null);
            }
            return bigDecimal;
        }

        private final BigDecimal roundSignificand(BigInteger significand, long exponent, DecimalMode decimalMode) {
            BigDecimal bigDecimal;
            if (Intrinsics.areEqual((Object)significand, (Object)BigInteger.Companion.getZERO())) {
                return new BigDecimal(BigInteger.Companion.getZERO(), exponent, decimalMode, null);
            }
            long significandDigits = significand.numberOfDecimalDigits();
            long desiredPrecision = decimalMode.getUsingScale() ? decimalMode.getDecimalPrecision() + decimalMode.getScale() : decimalMode.getDecimalPrecision();
            if (desiredPrecision > significandDigits) {
                BigInteger extendedSignificand = (BigInteger)significand.times((BigNumber)BigInteger.Companion.getTEN().pow(desiredPrecision - significandDigits));
                bigDecimal = new BigDecimal(extendedSignificand, exponent, decimalMode, null);
            } else if (desiredPrecision < significandDigits) {
                BigInteger.QuotientAndRemainder divRem = significand.divrem(BigInteger.Companion.getTEN().pow(significandDigits - desiredPrecision));
                BigInteger resolvedRemainder = divRem.getRemainder();
                if (Intrinsics.areEqual((Object)divRem.getRemainder(), (Object)BigInteger.Companion.getZERO())) {
                    return new BigDecimal(divRem.getQuotient(), exponent, decimalMode, null);
                }
                if (significand.numberOfDecimalDigits() == divRem.getQuotient().numberOfDecimalDigits() + divRem.getRemainder().numberOfDecimalDigits()) {
                    BigInteger newSignificand = this.roundDiscarded(divRem.getQuotient(), resolvedRemainder, decimalMode);
                    long exponentModifier = newSignificand.numberOfDecimalDigits() - divRem.getQuotient().numberOfDecimalDigits();
                    bigDecimal = new BigDecimal(newSignificand, exponent + exponentModifier, decimalMode, null);
                } else {
                    bigDecimal = this.handleZeroRounding(divRem.getQuotient(), exponent, decimalMode);
                }
            } else {
                bigDecimal = new BigDecimal(significand, exponent, decimalMode, null);
            }
            return bigDecimal;
        }

        private final BigDecimal applyScale(BigInteger significand, long exponent, DecimalMode decimalMode) {
            BigDecimal bigDecimal;
            DecimalMode decimalMode2;
            if (!decimalMode.getUsingScale()) {
                return new BigDecimal(significand, exponent, decimalMode, null);
            }
            if (exponent >= 0L) {
                decimalMode2 = new DecimalMode(exponent + decimalMode.getScale() + 1L, decimalMode.getRoundingMode(), 0L, 4, null);
            } else if (exponent < 0L) {
                decimalMode2 = new DecimalMode(decimalMode.getScale() + 1L, decimalMode.getRoundingMode(), 0L, 4, null);
            } else {
                throw new RuntimeException("Unexpected state");
            }
            DecimalMode workMode = decimalMode2;
            if (exponent >= 0L) {
                bigDecimal = this.roundSignificand(significand, exponent, workMode);
            } else {
                BigDecimal temp = (BigDecimal)new BigDecimal(significand, exponent, null, 4, null).plus(significand.signum());
                bigDecimal = (BigDecimal)this.roundSignificand(temp.getSignificand(), temp.getExponent(), workMode).minus(significand.signum());
            }
            return bigDecimal;
        }

        @NotNull
        public final BigDecimal fromBigDecimal(@NotNull BigDecimal bigDecimal, @Nullable DecimalMode decimalMode) {
            Intrinsics.checkNotNullParameter((Object)bigDecimal, (String)"bigDecimal");
            return new BigDecimal(bigDecimal.getSignificand(), bigDecimal.getExponent(), decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromBigDecimal$default(Companion companion, BigDecimal bigDecimal, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromBigDecimal(bigDecimal, decimalMode);
        }

        @NotNull
        public final BigDecimal fromBigInteger(@NotNull BigInteger bigInteger, @Nullable DecimalMode decimalMode) {
            Intrinsics.checkNotNullParameter((Object)bigInteger, (String)"bigInteger");
            return new BigDecimal(bigInteger, bigInteger.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromBigInteger$default(Companion companion, BigInteger bigInteger, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromBigInteger(bigInteger, decimalMode);
        }

        @NotNull
        public final BigDecimal fromLong(long l, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromLong(l);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromLong$default(Companion companion, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromLong(l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromULong-4PLdz1A(long uLong, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromULong-VKZWuLQ(uLong);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromULong-4PLdz1A$default(Companion companion, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromULong-4PLdz1A(l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromInt(int n, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromInt(n);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromInt$default(Companion companion, int n, DecimalMode decimalMode, int n2, Object object) {
            if ((n2 & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromInt(n, decimalMode);
        }

        @NotNull
        public final BigDecimal fromUInt-qim9Vi0(int uInt, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromUInt-WZ4Q5Ns(uInt);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromUInt-qim9Vi0$default(Companion companion, int n, DecimalMode decimalMode, int n2, Object object) {
            if ((n2 & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromUInt-qim9Vi0(n, decimalMode);
        }

        @NotNull
        public final BigDecimal fromUShort-vckuEUM(short uShort, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromUShort-xj2QHRw(uShort);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromUShort-vckuEUM$default(Companion companion, short s, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromUShort-vckuEUM(s, decimalMode);
        }

        @NotNull
        public final BigDecimal fromShort(short s, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromShort(s);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromShort$default(Companion companion, short s, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromShort(s, decimalMode);
        }

        @NotNull
        public final BigDecimal fromUByte-0ky7B_Q(byte uByte, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromUByte-7apg3OU(uByte);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromUByte-0ky7B_Q$default(Companion companion, byte by, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromUByte-0ky7B_Q(by, decimalMode);
        }

        @NotNull
        public final BigDecimal fromByte(byte by, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromByte(by);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromByte$default(Companion companion, byte by, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromByte(by, decimalMode);
        }

        @NotNull
        public final BigDecimal fromLongAsSignificand(long l, @Nullable DecimalMode decimalMode) {
            return new BigDecimal(BigInteger.Companion.fromLong(l), 0L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromLongAsSignificand$default(Companion companion, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromLongAsSignificand(l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromIntAsSignificand(int n, @Nullable DecimalMode decimalMode) {
            return new BigDecimal(BigInteger.Companion.fromInt(n), 0L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromIntAsSignificand$default(Companion companion, int n, DecimalMode decimalMode, int n2, Object object) {
            if ((n2 & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromIntAsSignificand(n, decimalMode);
        }

        @NotNull
        public final BigDecimal fromShortAsSignificand(short s, @Nullable DecimalMode decimalMode) {
            return new BigDecimal(BigInteger.Companion.fromShort(s), 0L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromShortAsSignificand$default(Companion companion, short s, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromShortAsSignificand(s, decimalMode);
        }

        @NotNull
        public final BigDecimal fromByteAsSignificand(byte by, @Nullable DecimalMode decimalMode) {
            return new BigDecimal(BigInteger.Companion.fromByte(by), 0L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromByteAsSignificand$default(Companion companion, byte by, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromByteAsSignificand(by, decimalMode);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BigDecimal fromFloat(float f, @Nullable DecimalMode decimalMode) {
            BigDecimal bigDecimal;
            String floatString = String.valueOf(f);
            if (StringsKt.contains$default((CharSequence)floatString, (char)'.', (boolean)false, (int)2, null) && !StringsKt.contains((CharSequence)floatString, (char)'E', (boolean)true)) {
                String string;
                Companion companion;
                block3: {
                    String string2 = floatString;
                    companion = this;
                    boolean $i$f$dropLastWhile = false;
                    for (int index$iv = StringsKt.getLastIndex((CharSequence)((CharSequence)$this$dropLastWhile$iv)); -1 < index$iv; --index$iv) {
                        void $this$dropLastWhile$iv;
                        char it = $this$dropLastWhile$iv.charAt(index$iv);
                        boolean bl = false;
                        if (it == '0') continue;
                        void var7_9 = $this$dropLastWhile$iv;
                        int n = 0;
                        int n2 = index$iv + 1;
                        String string3 = var7_9.substring(n, n2);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        break block3;
                    }
                    string = "";
                }
                bigDecimal = companion.parseStringWithMode(string, decimalMode).roundSignificand(decimalMode);
            } else {
                bigDecimal = this.parseStringWithMode(floatString, decimalMode).roundSignificand(decimalMode);
            }
            return bigDecimal;
        }

        public static /* synthetic */ BigDecimal fromFloat$default(Companion companion, float f, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromFloat(f, decimalMode);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BigDecimal fromDouble(double d, @Nullable DecimalMode decimalMode) {
            BigDecimal bigDecimal;
            String doubleString = String.valueOf(d);
            if (StringsKt.contains$default((CharSequence)doubleString, (char)'.', (boolean)false, (int)2, null) && !StringsKt.contains((CharSequence)doubleString, (char)'E', (boolean)true)) {
                String string;
                Companion companion;
                block3: {
                    String string2 = doubleString;
                    companion = this;
                    boolean $i$f$dropLastWhile = false;
                    for (int index$iv = StringsKt.getLastIndex((CharSequence)((CharSequence)$this$dropLastWhile$iv)); -1 < index$iv; --index$iv) {
                        void $this$dropLastWhile$iv;
                        char it = $this$dropLastWhile$iv.charAt(index$iv);
                        boolean bl = false;
                        if (it == '0') continue;
                        void var8_9 = $this$dropLastWhile$iv;
                        int n = 0;
                        int n2 = index$iv + 1;
                        String string3 = var8_9.substring(n, n2);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        break block3;
                    }
                    string = "";
                }
                bigDecimal = companion.parseStringWithMode(string, decimalMode).roundSignificand(decimalMode);
            } else {
                bigDecimal = this.parseStringWithMode(doubleString, decimalMode).roundSignificand(decimalMode).roundSignificand(decimalMode);
            }
            return bigDecimal;
        }

        public static /* synthetic */ BigDecimal fromDouble$default(Companion companion, double d, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromDouble(d, decimalMode);
        }

        @NotNull
        public final BigDecimal fromBigIntegerWithExponent(@NotNull BigInteger bigInteger, long exponent, @Nullable DecimalMode decimalMode) {
            Intrinsics.checkNotNullParameter((Object)bigInteger, (String)"bigInteger");
            return new BigDecimal(bigInteger, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromBigIntegerWithExponent$default(Companion companion, BigInteger bigInteger, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromBigIntegerWithExponent(bigInteger, l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromLongWithExponent(long l, long exponent, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromLong(l);
            return new BigDecimal(bigint, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromLongWithExponent$default(Companion companion, long l, long l2, DecimalMode decimalMode, int n, Object object) {
            if ((n & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromLongWithExponent(l, l2, decimalMode);
        }

        @NotNull
        public final BigDecimal fromIntWithExponent(int n, long exponent, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromInt(n);
            return new BigDecimal(bigint, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromIntWithExponent$default(Companion companion, int n, long l, DecimalMode decimalMode, int n2, Object object) {
            if ((n2 & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromIntWithExponent(n, l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromShortWithExponent(short s, long exponent, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromShort(s);
            return new BigDecimal(bigint, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromShortWithExponent$default(Companion companion, short s, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromShortWithExponent(s, l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromByteWithExponent(byte by, long exponent, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromByte(by);
            return new BigDecimal(bigint, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromByteWithExponent$default(Companion companion, byte by, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromByteWithExponent(by, l, decimalMode);
        }

        @Override
        @NotNull
        public BigDecimal fromBigInteger(@NotNull BigInteger bigInteger) {
            Intrinsics.checkNotNullParameter((Object)bigInteger, (String)"bigInteger");
            return this.fromBigInteger(bigInteger, null);
        }

        @Override
        @NotNull
        public BigDecimal fromULong-VKZWuLQ(long uLong) {
            return this.fromULong-4PLdz1A(uLong, null);
        }

        @Override
        @NotNull
        public BigDecimal fromUInt-WZ4Q5Ns(int uInt) {
            return this.fromUInt-qim9Vi0(uInt, null);
        }

        @Override
        @NotNull
        public BigDecimal fromUShort-xj2QHRw(short uShort) {
            return this.fromUShort-vckuEUM(uShort, null);
        }

        @Override
        @NotNull
        public BigDecimal fromUByte-7apg3OU(byte uByte) {
            return this.fromUByte-0ky7B_Q(uByte, null);
        }

        @Override
        @NotNull
        public BigDecimal fromLong(long l) {
            return this.fromLong(l, null);
        }

        @Override
        @NotNull
        public BigDecimal fromInt(int n) {
            return this.fromInt(n, null);
        }

        @Override
        @NotNull
        public BigDecimal fromShort(short s) {
            return this.fromShort(s, null);
        }

        @Override
        @NotNull
        public BigDecimal fromByte(byte by) {
            return this.fromByte(by, null);
        }

        @Override
        @NotNull
        public BigDecimal tryFromFloat(float f, boolean exactRequired) {
            return this.fromFloat(f, null);
        }

        @Override
        @NotNull
        public BigDecimal tryFromDouble(double d, boolean exactRequired) {
            return this.fromDouble(d, null);
        }

        @Override
        @NotNull
        public BigDecimal parseString(@NotNull String string, int base) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return this.parseStringWithMode(string, null);
        }

        @NotNull
        public final BigDecimal parseString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return net.mamoe.mirai.internal.deps.com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.parseStringWithMode$default(this, string, null, 2, null);
        }

        @NotNull
        public final BigDecimal parseStringWithMode(@NotNull String floatingPointString, @Nullable DecimalMode decimalMode) {
            Intrinsics.checkNotNullParameter((Object)floatingPointString, (String)"floatingPointString");
            if (((CharSequence)floatingPointString).length() == 0) {
                return this.getZERO();
            }
            if (StringsKt.contains((CharSequence)floatingPointString, (char)'E', (boolean)true)) {
                List split2;
                List list2;
                if (!StringsKt.contains$default((CharSequence)floatingPointString, (char)'.', (boolean)false, (int)2, null)) {
                    Object[] objectArray = new char[]{'E', 'e'};
                    List splitAroundE = StringsKt.split$default((CharSequence)floatingPointString, (char[])objectArray, (boolean)false, (int)0, (int)6, null);
                    objectArray = new String[2];
                    objectArray[0] = (char)((String)splitAroundE.get(0));
                    objectArray[1] = (char)("0E" + (String)splitAroundE.get(1));
                    list2 = CollectionsKt.listOf((Object[])objectArray);
                } else {
                    char[] cArray = new char[]{'.'};
                    list2 = split2 = StringsKt.split$default((CharSequence)floatingPointString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                }
                if (split2.size() == 2) {
                    int rightLastNonZero;
                    int leftFirstNonZero;
                    long exponent;
                    String right;
                    String left;
                    Sign sign;
                    block25: {
                        int n;
                        int n2;
                        block24: {
                            int n3;
                            int leftStart;
                            boolean signPresent = floatingPointString.charAt(0) == '-' || floatingPointString.charAt(0) == '+';
                            int n4 = leftStart = signPresent ? 1 : 0;
                            sign = signPresent ? (floatingPointString.charAt(0) == '-' ? Sign.NEGATIVE : Sign.POSITIVE) : Sign.POSITIVE;
                            String string = ((String)split2.get(0)).substring(leftStart);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            left = string;
                            char[] cArray = new char[]{'E', 'e'};
                            List rightSplit = StringsKt.split$default((CharSequence)((CharSequence)split2.get(1)), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                            right = (String)rightSplit.get(0);
                            String exponentSplit = (String)rightSplit.get(1);
                            boolean exponentSignPresent = exponentSplit.charAt(0) == '-' || exponentSplit.charAt(0) == '+';
                            Sign exponentSign = exponentSplit.charAt(0) == '-' ? Sign.NEGATIVE : Sign.POSITIVE;
                            int skipSignIfPresent = exponentSignPresent ? 1 : 0;
                            String string2 = exponentSplit.substring(skipSignIfPresent);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                            String exponentString = string2;
                            exponent = exponentSign == Sign.POSITIVE ? Long.parseLong(exponentString, CharsKt.checkRadix((int)10)) : Long.parseLong(exponentString, CharsKt.checkRadix((int)10)) * (long)-1;
                            CharSequence $this$indexOfFirst$iv = left;
                            boolean $i$f$indexOfFirst = false;
                            n2 = $this$indexOfFirst$iv.length();
                            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                                char it = $this$indexOfFirst$iv.charAt(index$iv);
                                boolean bl = false;
                                if (!(it != '0')) continue;
                                n3 = index$iv;
                                break block24;
                            }
                            n3 = leftFirstNonZero = -1;
                        }
                        if (leftFirstNonZero == -1) {
                            leftFirstNonZero = 0;
                        }
                        CharSequence $this$indexOfLast$iv = right;
                        boolean $i$f$indexOfLast = false;
                        n2 = $this$indexOfLast$iv.length() + -1;
                        if (0 <= n2) {
                            do {
                                int index$iv = n2--;
                                char it = $this$indexOfLast$iv.charAt(index$iv);
                                boolean bl = false;
                                if (!(it != '0')) continue;
                                n = index$iv;
                                break block25;
                            } while (0 <= n2);
                        }
                        n = rightLastNonZero = -1;
                    }
                    if (rightLastNonZero == -1) {
                        rightLastNonZero = right.length() - 1;
                    }
                    String string = left.substring(leftFirstNonZero, left.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String leftTruncated = string;
                    String string3 = right.substring(0, rightLastNonZero + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String rightTruncated = string3;
                    BigInteger significand = BigInteger.Companion.parseString(leftTruncated + rightTruncated, 10);
                    if (Intrinsics.areEqual((Object)significand, (Object)BigInteger.Companion.getZERO())) {
                        sign = Sign.ZERO;
                    }
                    if (sign == Sign.NEGATIVE) {
                        significand = significand.negate();
                    }
                    long exponentModifiedByFloatingPointPosition = !Intrinsics.areEqual((Object)leftTruncated, (Object)"0") ? exponent + (long)leftTruncated.length() - 1L : exponent - ((long)rightTruncated.length() - significand.numberOfDecimalDigits()) - 1L;
                    return new BigDecimal(significand, exponentModifiedByFloatingPointPosition, decimalMode, null);
                }
                throw new ArithmeticException("Invalid (or unsupported) floating point number format: " + floatingPointString);
            }
            if (StringsKt.contains$default((CharSequence)floatingPointString, (char)'.', (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'.'};
                List split3 = StringsKt.split$default((CharSequence)floatingPointString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                if (split3.size() == 2) {
                    int exponent;
                    int n;
                    int rightLastNonZero;
                    int leftFirstNonZero;
                    String right;
                    String left;
                    Sign sign;
                    block27: {
                        int n5;
                        int skipSignIfPresent;
                        block26: {
                            int n6;
                            int leftStart;
                            boolean signPresent = floatingPointString.charAt(0) == '-' || floatingPointString.charAt(0) == '+';
                            int n7 = leftStart = signPresent ? 1 : 0;
                            sign = signPresent ? (floatingPointString.charAt(0) == '-' ? Sign.NEGATIVE : Sign.POSITIVE) : Sign.POSITIVE;
                            String string = ((String)split3.get(0)).substring(leftStart);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            left = string;
                            right = (String)split3.get(1);
                            CharSequence $this$indexOfFirst$iv = left;
                            boolean $i$f$indexOfFirst = false;
                            skipSignIfPresent = $this$indexOfFirst$iv.length();
                            for (int index$iv = 0; index$iv < skipSignIfPresent; ++index$iv) {
                                char it = $this$indexOfFirst$iv.charAt(index$iv);
                                boolean bl = false;
                                if (!(it != '0')) continue;
                                n6 = index$iv;
                                break block26;
                            }
                            n6 = leftFirstNonZero = -1;
                        }
                        if (leftFirstNonZero == -1) {
                            leftFirstNonZero = 0;
                        }
                        CharSequence $this$indexOfLast$iv = right;
                        boolean $i$f$indexOfLast = false;
                        skipSignIfPresent = $this$indexOfLast$iv.length() + -1;
                        if (0 <= skipSignIfPresent) {
                            do {
                                int index$iv = skipSignIfPresent--;
                                char it = $this$indexOfLast$iv.charAt(index$iv);
                                boolean bl = false;
                                if (!(it != '0')) continue;
                                n5 = index$iv;
                                break block27;
                            } while (0 <= skipSignIfPresent);
                        }
                        n5 = rightLastNonZero = -1;
                    }
                    if (rightLastNonZero == -1) {
                        rightLastNonZero = right.length() - 1;
                    }
                    String string = left.substring(leftFirstNonZero, left.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String leftTruncated = string;
                    String string4 = right.substring(0, rightLastNonZero + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String rightTruncated = string4;
                    BigInteger significand = BigInteger.Companion.parseString(leftTruncated + rightTruncated, 10);
                    if (((CharSequence)leftTruncated).length() > 0 && leftTruncated.charAt(0) != '0') {
                        n = leftTruncated.length() - 1;
                    } else {
                        int n8;
                        block28: {
                            CharSequence $this$indexOfFirst$iv = rightTruncated;
                            boolean $i$f$indexOfFirst = false;
                            int n9 = $this$indexOfFirst$iv.length();
                            for (int index$iv = 0; index$iv < n9; ++index$iv) {
                                char it = $this$indexOfFirst$iv.charAt(index$iv);
                                boolean bl = false;
                                if (!(it != '0')) continue;
                                n8 = index$iv;
                                break block28;
                            }
                            n8 = -1;
                        }
                        n = exponent = (n8 + 1) * -1;
                    }
                    if (Intrinsics.areEqual((Object)significand, (Object)BigInteger.Companion.getZERO())) {
                        sign = Sign.ZERO;
                    }
                    if (sign == Sign.NEGATIVE) {
                        significand = significand.negate();
                    }
                    return new BigDecimal(significand, exponent, decimalMode, null);
                }
                throw new ArithmeticException("Invalid (or unsupported) floating point number format: " + floatingPointString);
            }
            BigInteger significand = BigInteger.Companion.parseString(floatingPointString, 10);
            return new BigDecimal(significand, significand.numberOfDecimalDigits() - 1L, decimalMode, null);
        }

        public static /* synthetic */ BigDecimal parseStringWithMode$default(Companion companion, String string, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.parseStringWithMode(string, decimalMode);
        }

        private final DecimalMode resolveDecimalMode(DecimalMode firstDecimalMode, DecimalMode secondDecimalMode, DecimalMode suppliedDecimalMode) {
            DecimalMode decimalMode;
            if (suppliedDecimalMode != null) {
                decimalMode = suppliedDecimalMode;
            } else {
                DecimalMode unifiedDecimalMode;
                if (firstDecimalMode == null && secondDecimalMode == null) {
                    return new DecimalMode(0L, null, 0L, 7, null);
                }
                if (firstDecimalMode == null && secondDecimalMode != null) {
                    return secondDecimalMode;
                }
                if (secondDecimalMode == null && firstDecimalMode != null) {
                    return firstDecimalMode;
                }
                DecimalMode decimalMode2 = firstDecimalMode;
                Intrinsics.checkNotNull((Object)decimalMode2);
                RoundingMode roundingMode = decimalMode2.getRoundingMode();
                DecimalMode decimalMode3 = secondDecimalMode;
                Intrinsics.checkNotNull((Object)decimalMode3);
                if (roundingMode != decimalMode3.getRoundingMode()) {
                    throw new ArithmeticException("Different rounding modes! This: " + (Object)((Object)firstDecimalMode.getRoundingMode()) + " Other: " + (Object)((Object)secondDecimalMode.getRoundingMode()));
                }
                decimalMode = unifiedDecimalMode = firstDecimalMode.getDecimalPrecision() >= secondDecimalMode.getDecimalPrecision() ? firstDecimalMode : secondDecimalMode;
            }
            return decimalMode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/BigDecimal$Companion$SignificantDecider;", "", "(Ljava/lang/String;I)V", "FIVE", "LESS_THAN_FIVE", "MORE_THAN_FIVE", "bignum"})
        private static final class SignificantDecider
        extends Enum<SignificantDecider> {
            public static final /* enum */ SignificantDecider FIVE = new SignificantDecider();
            public static final /* enum */ SignificantDecider LESS_THAN_FIVE = new SignificantDecider();
            public static final /* enum */ SignificantDecider MORE_THAN_FIVE = new SignificantDecider();
            private static final /* synthetic */ SignificantDecider[] $VALUES;

            public static SignificantDecider[] values() {
                return (SignificantDecider[])$VALUES.clone();
            }

            public static SignificantDecider valueOf(String value) {
                return Enum.valueOf(SignificantDecider.class, value);
            }

            static {
                $VALUES = significantDeciderArray = new SignificantDecider[]{SignificantDecider.FIVE, SignificantDecider.LESS_THAN_FIVE, SignificantDecider.MORE_THAN_FIVE};
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Sign.values().length];
                nArray[Sign.POSITIVE.ordinal()] = 1;
                nArray[Sign.NEGATIVE.ordinal()] = 2;
                nArray[Sign.ZERO.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[RoundingMode.values().length];
                nArray[RoundingMode.AWAY_FROM_ZERO.ordinal()] = 1;
                nArray[RoundingMode.TOWARDS_ZERO.ordinal()] = 2;
                nArray[RoundingMode.CEILING.ordinal()] = 3;
                nArray[RoundingMode.FLOOR.ordinal()] = 4;
                nArray[RoundingMode.ROUND_HALF_AWAY_FROM_ZERO.ordinal()] = 5;
                nArray[RoundingMode.ROUND_HALF_TOWARDS_ZERO.ordinal()] = 6;
                nArray[RoundingMode.ROUND_HALF_CEILING.ordinal()] = 7;
                nArray[RoundingMode.ROUND_HALF_FLOOR.ordinal()] = 8;
                nArray[RoundingMode.ROUND_HALF_TO_EVEN.ordinal()] = 9;
                nArray[RoundingMode.ROUND_HALF_TO_ODD.ordinal()] = 10;
                nArray[RoundingMode.NONE.ordinal()] = 11;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/mamoe/mirai/internal/deps/com/ionspin/kotlin/bignum/decimal/BigDecimal$ScaleOps;", "", "(Ljava/lang/String;I)V", "Max", "Min", "Add", "bignum"})
    private static final class ScaleOps
    extends Enum<ScaleOps> {
        public static final /* enum */ ScaleOps Max = new ScaleOps();
        public static final /* enum */ ScaleOps Min = new ScaleOps();
        public static final /* enum */ ScaleOps Add = new ScaleOps();
        private static final /* synthetic */ ScaleOps[] $VALUES;

        public static ScaleOps[] values() {
            return (ScaleOps[])$VALUES.clone();
        }

        public static ScaleOps valueOf(String value) {
            return Enum.valueOf(ScaleOps.class, value);
        }

        static {
            $VALUES = scaleOpsArray = new ScaleOps[]{ScaleOps.Max, ScaleOps.Min, ScaleOps.Add};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Sign.values().length];
            nArray[Sign.POSITIVE.ordinal()] = 1;
            nArray[Sign.NEGATIVE.ordinal()] = 2;
            nArray[Sign.ZERO.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScaleOps.values().length];
            nArray[ScaleOps.Max.ordinal()] = 1;
            nArray[ScaleOps.Min.ordinal()] = 2;
            nArray[ScaleOps.Add.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

