/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.deps.io.ktor.client.request;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import net.mamoe.mirai.internal.deps.io.ktor.client.engine.HttpClientEngineCapability;
import net.mamoe.mirai.internal.deps.io.ktor.client.engine.HttpClientEngineCapabilityKt;
import net.mamoe.mirai.internal.deps.io.ktor.client.request.HttpRequestBuilder;
import net.mamoe.mirai.internal.deps.io.ktor.client.request.HttpRequestData;
import net.mamoe.mirai.internal.deps.io.ktor.client.request.RequestBodyKt;
import net.mamoe.mirai.internal.deps.io.ktor.client.utils.EmptyContent;
import net.mamoe.mirai.internal.deps.io.ktor.http.HeadersBuilder;
import net.mamoe.mirai.internal.deps.io.ktor.http.HttpMessageBuilder;
import net.mamoe.mirai.internal.deps.io.ktor.http.HttpMethod;
import net.mamoe.mirai.internal.deps.io.ktor.http.URLBuilder;
import net.mamoe.mirai.internal.deps.io.ktor.http.URLUtilsKt;
import net.mamoe.mirai.internal.deps.io.ktor.http.content.OutgoingContent;
import net.mamoe.mirai.internal.deps.io.ktor.util.Attributes;
import net.mamoe.mirai.internal.deps.io.ktor.util.AttributesJvmKt;
import net.mamoe.mirai.internal.deps.io.ktor.util.AttributesKt;
import net.mamoe.mirai.internal.deps.io.ktor.util.InternalAPI;
import net.mamoe.mirai.internal.deps.io.ktor.util.StringValuesKt;
import net.mamoe.mirai.internal.deps.io.ktor.util.reflect.TypeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 <2\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010)\u001a\u00020*J%\u0010+\u001a\u0004\u0018\u0001H,\"\b\b\u0000\u0010,*\u00020\b2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H,0.\u00a2\u0006\u0002\u0010/J\u001f\u00100\u001a\u0002012\u0017\u00102\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020103\u00a2\u0006\u0002\b4J+\u00105\u001a\u000201\"\b\b\u0000\u0010,*\u00020\b2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H,0.2\u0006\u00106\u001a\u0002H,\u00a2\u0006\u0002\u00107J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0000J\u0010\u0010:\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0000H\u0007J%\u0010%\u001a\u0002012\u001d\u00102\u001a\u0019\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u0002010;\u00a2\u0006\u0002\b4R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0015@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006="}, d2={"Lnet/mamoe/mirai/internal/deps/io/ktor/client/request/HttpRequestBuilder;", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/HttpMessageBuilder;", "()V", "attributes", "Lnet/mamoe/mirai/internal/deps/io/ktor/util/Attributes;", "getAttributes", "()Lio/ktor/util/Attributes;", "<set-?>", "", "body", "getBody", "()Ljava/lang/Object;", "setBody", "(Ljava/lang/Object;)V", "value", "Lnet/mamoe/mirai/internal/deps/io/ktor/util/reflect/TypeInfo;", "bodyType", "getBodyType", "()Lio/ktor/util/reflect/TypeInfo;", "setBodyType", "(Lio/ktor/util/reflect/TypeInfo;)V", "Lkotlinx/coroutines/Job;", "executionContext", "getExecutionContext", "()Lkotlinx/coroutines/Job;", "setExecutionContext$ktor_client_core", "(Lkotlinx/coroutines/Job;)V", "headers", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/HeadersBuilder;", "getHeaders", "()Lio/ktor/http/HeadersBuilder;", "method", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "setMethod", "(Lio/ktor/http/HttpMethod;)V", "url", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/URLBuilder;", "getUrl", "()Lio/ktor/http/URLBuilder;", "build", "Lnet/mamoe/mirai/internal/deps/io/ktor/client/request/HttpRequestData;", "getCapabilityOrNull", "T", "key", "Lnet/mamoe/mirai/internal/deps/io/ktor/client/engine/HttpClientEngineCapability;", "(Lio/ktor/client/engine/HttpClientEngineCapability;)Ljava/lang/Object;", "setAttributes", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "setCapability", "capability", "(Lio/ktor/client/engine/HttpClientEngineCapability;Ljava/lang/Object;)V", "takeFrom", "builder", "takeFromWithExecutionContext", "Lkotlin/Function2;", "Companion", "ktor-client-core"})
public final class HttpRequestBuilder
implements HttpMessageBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URLBuilder url = new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null);
    @NotNull
    private HttpMethod method = HttpMethod.Companion.getGet();
    @NotNull
    private final HeadersBuilder headers = new HeadersBuilder(0, 1, null);
    @NotNull
    private Object body = EmptyContent.INSTANCE;
    @NotNull
    private Job executionContext = (Job)SupervisorKt.SupervisorJob$default(null, (int)1, null);
    @NotNull
    private final Attributes attributes = AttributesJvmKt.Attributes(true);

    @NotNull
    public final URLBuilder getUrl() {
        return this.url;
    }

    @NotNull
    public final HttpMethod getMethod() {
        return this.method;
    }

    public final void setMethod(@NotNull HttpMethod httpMethod) {
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"<set-?>");
        this.method = httpMethod;
    }

    @Override
    @NotNull
    public HeadersBuilder getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Object getBody() {
        return this.body;
    }

    @InternalAPI
    public final void setBody(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.body = object;
    }

    @Nullable
    public final TypeInfo getBodyType() {
        return this.attributes.getOrNull(RequestBodyKt.getBodyTypeAttributeKey());
    }

    @InternalAPI
    public final void setBodyType(@Nullable TypeInfo value) {
        if (value != null) {
            this.attributes.put(RequestBodyKt.getBodyTypeAttributeKey(), value);
        } else {
            this.attributes.remove(RequestBodyKt.getBodyTypeAttributeKey());
        }
    }

    @NotNull
    public final Job getExecutionContext() {
        return this.executionContext;
    }

    public final void setExecutionContext$ktor_client_core(@NotNull Job job2) {
        Intrinsics.checkNotNullParameter((Object)job2, (String)"<set-?>");
        this.executionContext = job2;
    }

    @NotNull
    public final Attributes getAttributes() {
        return this.attributes;
    }

    public final void url(@NotNull Function2<? super URLBuilder, ? super URLBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        block.invoke((Object)this.url, (Object)this.url);
    }

    @NotNull
    public final HttpRequestData build() {
        Object object = this.body;
        OutgoingContent outgoingContent = object instanceof OutgoingContent ? (OutgoingContent)object : null;
        if (outgoingContent == null) {
            throw new IllegalStateException(("No request transformation found: " + this.body).toString());
        }
        return new HttpRequestData(this.url.build(), this.method, this.getHeaders().build(), outgoingContent, this.executionContext, this.attributes);
    }

    public final void setAttributes(@NotNull Function1<? super Attributes, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Attributes attributes2 = this.attributes;
        block.invoke((Object)attributes2);
    }

    @InternalAPI
    @NotNull
    public final HttpRequestBuilder takeFromWithExecutionContext(@NotNull HttpRequestBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.executionContext = builder.executionContext;
        return this.takeFrom(builder);
    }

    @NotNull
    public final HttpRequestBuilder takeFrom(@NotNull HttpRequestBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.method = builder.method;
        this.body = builder.body;
        this.setBodyType(builder.getBodyType());
        URLUtilsKt.takeFrom(this.url, builder.url);
        this.url.setEncodedPathSegments(this.url.getEncodedPathSegments());
        StringValuesKt.appendAll(this.getHeaders(), builder.getHeaders());
        AttributesKt.putAll(this.attributes, builder.attributes);
        return this;
    }

    public final <T> void setCapability(@NotNull HttpClientEngineCapability<T> key, @NotNull T capability) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        Map<HttpClientEngineCapability<?>, Object> capabilities2 = this.attributes.computeIfAbsent(HttpClientEngineCapabilityKt.getENGINE_CAPABILITIES_KEY(), setCapability.capabilities.1.INSTANCE);
        capabilities2.put(key, capability);
    }

    @Nullable
    public final <T> T getCapabilityOrNull(@NotNull HttpClientEngineCapability<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Map<HttpClientEngineCapability<?>, Object> map2 = this.attributes.getOrNull(HttpClientEngineCapabilityKt.getENGINE_CAPABILITIES_KEY());
        return (T)(map2 != null ? map2.get(key) : null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/mamoe/mirai/internal/deps/io/ktor/client/request/HttpRequestBuilder$Companion;", "", "()V", "ktor-client-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

