/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.deps.io.ktor.http;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.deps.io.ktor.http.HttpHeaders;
import net.mamoe.mirai.internal.deps.io.ktor.http.HttpMessage;
import net.mamoe.mirai.internal.deps.io.ktor.http.HttpMessageBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\t\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\u000b\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"HTTP_DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "getHTTP_DATE_FORMAT", "()Ljava/text/SimpleDateFormat;", "formatHttpDate", "", "date", "Ljava/util/Date;", "parseHttpDate", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/HttpMessage;", "expires", "Lnet/mamoe/mirai/internal/deps/io/ktor/http/HttpMessageBuilder;", "ifModifiedSince", "", "lastModified", "ktor-http"})
public final class HttpMessagePropertiesJvmKt {
    private static final SimpleDateFormat getHTTP_DATE_FORMAT() {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat $this$_get_HTTP_DATE_FORMAT__u24lambda_u2d0 = simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        boolean bl = false;
        $this$_get_HTTP_DATE_FORMAT__u24lambda_u2d0.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }

    private static final Date parseHttpDate(String date) {
        Date date2 = HttpMessagePropertiesJvmKt.getHTTP_DATE_FORMAT().parse(date);
        Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"HTTP_DATE_FORMAT.parse(date)");
        return date2;
    }

    private static final String formatHttpDate(Date date) {
        String string = HttpMessagePropertiesJvmKt.getHTTP_DATE_FORMAT().format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HTTP_DATE_FORMAT.format(date)");
        return string;
    }

    public static final void ifModifiedSince(@NotNull HttpMessageBuilder $this$ifModifiedSince, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)$this$ifModifiedSince, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        $this$ifModifiedSince.getHeaders().set(HttpHeaders.INSTANCE.getIfModifiedSince(), HttpMessagePropertiesJvmKt.formatHttpDate(date));
    }

    @Nullable
    public static final Date lastModified(@NotNull HttpMessageBuilder $this$lastModified) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$lastModified, (String)"<this>");
        String string = $this$lastModified.getHeaders().get(HttpHeaders.INSTANCE.getLastModified());
        if (string != null) {
            String it = string;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date expires(@NotNull HttpMessageBuilder $this$expires) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$expires, (String)"<this>");
        String string = $this$expires.getHeaders().get(HttpHeaders.INSTANCE.getExpires());
        if (string != null) {
            String it = string;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date lastModified(@NotNull HttpMessage $this$lastModified) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$lastModified, (String)"<this>");
        String string = $this$lastModified.getHeaders().get(HttpHeaders.INSTANCE.getLastModified());
        if (string != null) {
            String it = string;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date expires(@NotNull HttpMessage $this$expires) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$expires, (String)"<this>");
        String string = $this$expires.getHeaders().get(HttpHeaders.INSTANCE.getExpires());
        if (string != null) {
            String it = string;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date date(@NotNull HttpMessage $this$date) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$date, (String)"<this>");
        String string = $this$date.getHeaders().get(HttpHeaders.INSTANCE.getDate());
        if (string != null) {
            String it = string;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }
}

