/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.message.image;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.CloseableJVMKt;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.Input;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.InputLittleEndianKt;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.InputPrimitivesKt;
import net.mamoe.mirai.internal.deps.io.ktor.utils.io.core.StringsKt;
import net.mamoe.mirai.internal.message.image.ImageInfo;
import net.mamoe.mirai.message.data.ImageType;
import net.mamoe.mirai.utils.CloseableKt;
import net.mamoe.mirai.utils.ExternalResource;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\f\u0010\t\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\f\u0010\n\u001a\u00020\u0004*\u00020\u0007H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"JPG_SOF_RANGE", "", "Lkotlin/ranges/IntRange;", "calculateImageInfo", "Lnet/mamoe/mirai/internal/message/image/ImageInfo;", "Lnet/mamoe/mirai/utils/ExternalResource;", "getBMPImageInfo", "Lnet/mamoe/mirai/internal/deps/io/ktor/utils/io/core/Input;", "getGIFImageInfo", "getJPGImageInfo", "getPNGImageInfo", "mirai-core"})
@SourceDebugExtension(value={"SMAP\nImageDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDecoder.kt\nnet/mamoe/mirai/internal/message/image/ImageDecoderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Closeable.kt\nnet/mamoe/mirai/utils/CloseableKt_common\n+ 5 Closeable.kt\nio/ktor/utils/io/core/CloseableKt\n*L\n1#1,168:1\n1747#2,3:169\n1#3:172\n57#4,4:173\n32#4,4:177\n8#5,4:181\n22#5,4:185\n12#5,10:189\n*S KotlinDebug\n*F\n+ 1 ImageDecoder.kt\nnet/mamoe/mirai/internal/message/image/ImageDecoderKt\n*L\n36#1:169,3\n152#1:173,4\n152#1:177,4\n152#1:181,4\n152#1:185,4\n152#1:189,10\n*E\n"})
public final class ImageDecoderKt {
    @NotNull
    private static final List<IntRange> JPG_SOF_RANGE;

    private static final ImageInfo getJPGImageInfo(Input $this$getJPGImageInfo) {
        byte[] byArray;
        byte[] byArray2 = StringsKt.readBytes((Input)$this$getJPGImageInfo, (int)2);
        if (!Arrays.equals(byArray2, byArray = new byte[]{-1, -40})) {
            boolean $i$a$-require-ImageDecoderKt$getJPGImageInfo$22 = false;
            String $i$a$-require-ImageDecoderKt$getJPGImageInfo$22 = "It's not a valid jpg file";
            throw new IllegalArgumentException($i$a$-require-ImageDecoderKt$getJPGImageInfo$22.toString());
        }
        while ($this$getJPGImageInfo.readByte() == -1) {
            boolean bl;
            int type;
            block6: {
                type = MiraiUtils.toIntUnsigned((byte)$this$getJPGImageInfo.readByte());
                Iterable $this$any$iv = JPG_SOF_RANGE;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IntRange it = (IntRange)element$iv;
                        boolean bl2 = false;
                        if (!it.contains(type)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                $this$getJPGImageInfo.discardExact(2);
                $this$getJPGImageInfo.discardExact(1);
                short height = InputPrimitivesKt.readShort((Input)$this$getJPGImageInfo);
                short width = InputPrimitivesKt.readShort((Input)$this$getJPGImageInfo);
                return new ImageInfo(width, height, ImageType.JPG);
            }
            int n = type;
            if (n == 218) break;
            if (0 <= n ? n < 2 : false) continue;
            if (208 <= n ? n < 216 : false) continue;
            $this$getJPGImageInfo.discardExact(MiraiUtils.toIntUnsigned((short)InputPrimitivesKt.readShort((Input)$this$getJPGImageInfo)) - 2);
        }
        throw new IllegalArgumentException("It's not a valid jpg file, failed to find an SOF segment");
    }

    private static final ImageInfo getBMPImageInfo(Input $this$getBMPImageInfo) {
        if (!Intrinsics.areEqual((Object)MiraiUtils.readString$default((Input)$this$getBMPImageInfo, (int)2, null, (int)2, null), (Object)"BM")) {
            boolean bl = false;
            String string = "It's not a valid bmp file";
            throw new IllegalArgumentException(string.toString());
        }
        $this$getBMPImageInfo.discardExact(4);
        $this$getBMPImageInfo.discardExact(4);
        $this$getBMPImageInfo.discardExact(4);
        $this$getBMPImageInfo.discardExact(4);
        return new ImageInfo(InputLittleEndianKt.readIntLittleEndian((Input)$this$getBMPImageInfo), InputLittleEndianKt.readIntLittleEndian((Input)$this$getBMPImageInfo), ImageType.BMP);
    }

    private static final ImageInfo getPNGImageInfo(Input $this$getPNGImageInfo) {
        byte[] byArray = StringsKt.readBytes((Input)$this$getPNGImageInfo, (int)8);
        byte[] byArray2 = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (!Arrays.equals(byArray, byArray2)) {
            boolean $i$a$-require-ImageDecoderKt$getPNGImageInfo$32 = false;
            String $i$a$-require-ImageDecoderKt$getPNGImageInfo$32 = "It's not a valid png file";
            throw new IllegalArgumentException($i$a$-require-ImageDecoderKt$getPNGImageInfo$32.toString());
        }
        $this$getPNGImageInfo.discardExact(4);
        String type = MiraiUtils.readString$default((Input)$this$getPNGImageInfo, (int)4, null, (int)2, null);
        if (!Intrinsics.areEqual((Object)type, (Object)"IHDR")) {
            boolean $i$a$-require-ImageDecoderKt$getPNGImageInfo$42 = false;
            String $i$a$-require-ImageDecoderKt$getPNGImageInfo$42 = "It's not a valid png file, First chunk must be IHDR";
            throw new IllegalArgumentException($i$a$-require-ImageDecoderKt$getPNGImageInfo$42.toString());
        }
        int width = InputPrimitivesKt.readInt((Input)$this$getPNGImageInfo);
        int height = InputPrimitivesKt.readInt((Input)$this$getPNGImageInfo);
        $this$getPNGImageInfo.discardExact(9);
        $this$getPNGImageInfo.discardExact(4);
        type = MiraiUtils.readString$default((Input)$this$getPNGImageInfo, (int)4, null, (int)2, null);
        return new ImageInfo(width, height, Intrinsics.areEqual((Object)type, (Object)"acTL") ? ImageType.APNG : ImageType.PNG);
    }

    private static final ImageInfo getGIFImageInfo(Input $this$getGIFImageInfo) {
        String $this$getGIFImageInfo_u24lambda_u245 = MiraiUtils.readString$default((Input)$this$getGIFImageInfo, (int)6, null, (int)2, null);
        boolean bl = false;
        if (!(kotlin.text.StringsKt.startsWith$default((String)$this$getGIFImageInfo_u24lambda_u245, (String)"GIF", (boolean)false, (int)2, null) && kotlin.text.StringsKt.endsWith$default((String)$this$getGIFImageInfo_u24lambda_u245, (String)"a", (boolean)false, (int)2, null))) {
            boolean bl2 = false;
            String string = "It's not a valid gif file";
            throw new IllegalArgumentException(string.toString());
        }
        return new ImageInfo(InputLittleEndianKt.readShortLittleEndian((Input)$this$getGIFImageInfo), InputLittleEndianKt.readShortLittleEndian((Input)$this$getGIFImageInfo), ImageType.GIF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ImageInfo calculateImageInfo(@NotNull ExternalResource $this$calculateImageInfo) throws IOException, IllegalArgumentException {
        ImageInfo imageInfo;
        Intrinsics.checkNotNullParameter((Object)$this$calculateImageInfo, (String)"<this>");
        ImageType imageType = ImageType.Companion.match($this$calculateImageInfo.getFormatName());
        Input $this$withUse$iv = $this$calculateImageInfo.input();
        boolean $i$f$withUse = false;
        Input $this$use$iv$iv = $this$withUse$iv;
        boolean $i$f$use = false;
        Closeable $this$use$iv$iv$iv = CloseableKt.asMiraiCloseable((Closeable)((Closeable)$this$use$iv$iv));
        boolean $i$f$use2 = false;
        boolean closed$iv$iv$iv = false;
        try {
            ImageInfo imageInfo2;
            Closeable it$iv$iv = $this$use$iv$iv$iv;
            boolean bl = false;
            Input $this$calculateImageInfo_u24lambda_u247 = $this$use$iv$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[imageType.ordinal()]) {
                case 1: {
                    imageInfo2 = ImageDecoderKt.getJPGImageInfo($this$calculateImageInfo_u24lambda_u247);
                    break;
                }
                case 2: {
                    imageInfo2 = ImageDecoderKt.getBMPImageInfo($this$calculateImageInfo_u24lambda_u247);
                    break;
                }
                case 3: {
                    imageInfo2 = ImageDecoderKt.getGIFImageInfo($this$calculateImageInfo_u24lambda_u247);
                    break;
                }
                case 4: 
                case 5: {
                    imageInfo2 = ImageDecoderKt.getPNGImageInfo($this$calculateImageInfo_u24lambda_u247);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type (" + $this$calculateImageInfo.getFormatName() + ") for ExternalResource " + $this$calculateImageInfo + ", considering use gif/png/bmp/jpg format. image header: " + MiraiUtils.toUHexString$default((byte[])StringsKt.readBytesOf$default((Input)$this$calculateImageInfo_u24lambda_u247, (int)0, (int)30, (int)1, null), null, (int)0, (int)0, (int)7, null));
                }
            }
            imageInfo = imageInfo2;
        }
        catch (Throwable first$iv$iv$iv) {
            try {
                try {
                    closed$iv$iv$iv = true;
                    $this$use$iv$iv$iv.close();
                }
                catch (Throwable second$iv$iv$iv) {
                    CloseableJVMKt.addSuppressedInternal((Throwable)first$iv$iv$iv, (Throwable)second$iv$iv$iv);
                }
                throw first$iv$iv$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv$iv$iv) {
                    $this$use$iv$iv$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv$iv$iv.close();
        return imageInfo;
    }

    static {
        Object[] objectArray = new IntRange[]{new IntRange(192, 195), new IntRange(197, 199), new IntRange(201, 203), new IntRange(205, 207)};
        JPG_SOF_RANGE = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageType.values().length];
            try {
                nArray[ImageType.JPG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageType.BMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageType.GIF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageType.PNG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageType.APNG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

