/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.crypto;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.mamoe.mirai.internal.utils.crypto.RSAKeyPair;
import net.mamoe.mirai.utils.ActualsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\r"}, d2={"generateRSAKeyPair", "Lnet/mamoe/mirai/internal/utils/crypto/RSAKeyPair;", "keySize", "", "rsaDecryptWithPKCS8PrivKey", "", "input", "plainPrivPemKey", "", "seed", "", "rsaEncryptWithX509PubKey", "plainPubPemKey", "mirai-core"})
@SourceDebugExtension(value={"SMAP\nRSA.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RSA.kt\nnet/mamoe/mirai/internal/utils/crypto/RSAKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n1855#3,2:76\n1855#3,2:78\n*S KotlinDebug\n*F\n+ 1 RSA.kt\nnet/mamoe/mirai/internal/utils/crypto/RSAKt\n*L\n65#1:76,2\n70#1:78,2\n*E\n"})
public final class RSAKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] rsaEncryptWithX509PubKey(@NotNull byte[] input, @NotNull String plainPubPemKey, long seed) {
        void $this$rsaEncryptWithX509PubKey_u24lambda_u240;
        SecureRandom secureRandom;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)plainPubPemKey, (String)"plainPubPemKey");
        byte[] encodedKey = ActualsKt.decodeBase64((String)((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.replace$default((String)plainPubPemKey, (String)"\n", (String)"", (boolean)false, (int)4, null), (CharSequence)"-----BEGIN PUBLIC KEY-----"), (CharSequence)"-----END PUBLIC KEY-----"))).toString());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey rsaPubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        SecureRandom secureRandom2 = secureRandom = new SecureRandom();
        Key key = rsaPubKey;
        int n = 1;
        Cipher cipher2 = cipher;
        boolean bl = false;
        $this$rsaEncryptWithX509PubKey_u24lambda_u240.setSeed(seed);
        Unit unit = Unit.INSTANCE;
        cipher2.init(n, key, secureRandom);
        byte[] byArray = cipher.doFinal(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(input)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] rsaDecryptWithPKCS8PrivKey(@NotNull byte[] input, @NotNull String plainPrivPemKey, long seed) {
        void $this$rsaDecryptWithPKCS8PrivKey_u24lambda_u241;
        SecureRandom secureRandom;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)plainPrivPemKey, (String)"plainPrivPemKey");
        byte[] encodedKey = ActualsKt.decodeBase64((String)((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.replace$default((String)plainPrivPemKey, (String)"\n", (String)"", (boolean)false, (int)4, null), (CharSequence)"-----BEGIN PRIVATE KEY-----"), (CharSequence)"-----END PRIVATE KEY-----"))).toString());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey rsaPubKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        SecureRandom secureRandom2 = secureRandom = new SecureRandom();
        Key key = rsaPubKey;
        int n = 2;
        Cipher cipher2 = cipher;
        boolean bl = false;
        $this$rsaDecryptWithPKCS8PrivKey_u24lambda_u241.setSeed(seed);
        Unit unit = Unit.INSTANCE;
        cipher2.init(n, key, secureRandom);
        byte[] byArray = cipher.doFinal(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(input)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RSAKeyPair generateRSAKeyPair(int keySize) {
        void $this$generateRSAKeyPair_u24lambda_u244;
        String p0;
        StringBuilder stringBuilder;
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(keySize);
        KeyPair keyPair = keyGen.generateKeyPair();
        StringBuilder $this$generateRSAKeyPair_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$generateRSAKeyPair_u24lambda_u242.append("-----BEGIN PUBLIC KEY-----");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        byte[] byArray = keyPair.getPublic().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.public.encoded");
        Iterable $this$forEach$iv = StringsKt.chunked((CharSequence)ActualsKt.encodeBase64((byte[])byArray), (int)64);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (String)element$iv;
            boolean bl2 = false;
            boolean $i$f$generateRSAKeyPair$lambda$2$appendLine = false;
            StringBuilder stringBuilder3 = $this$generateRSAKeyPair_u24lambda_u242.append(p0);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder4 = $this$generateRSAKeyPair_u24lambda_u242.append("-----END PUBLIC KEY-----");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        $this$generateRSAKeyPair_u24lambda_u242 = stringBuilder = new StringBuilder();
        String string2 = string;
        boolean bl3 = false;
        StringBuilder stringBuilder5 = $this$generateRSAKeyPair_u24lambda_u244.append("-----BEGIN PRIVATE KEY-----");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        byte[] byArray2 = keyPair.getPrivate().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"keyPair.private.encoded");
        $this$forEach$iv = StringsKt.chunked((CharSequence)ActualsKt.encodeBase64((byte[])byArray2), (int)64);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (String)element$iv;
            boolean bl4 = false;
            boolean $i$f$generateRSAKeyPair$lambda$4$appendLine$3 = false;
            StringBuilder stringBuilder6 = $this$generateRSAKeyPair_u24lambda_u244.append(p0);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder7 = $this$generateRSAKeyPair_u24lambda_u244.append("-----END PRIVATE KEY-----");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        String string4 = string3;
        String string5 = string2;
        return new RSAKeyPair(string5, string4);
    }
}

