/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.digest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import net.nicoulaj.maven.plugins.checksum.digest.AbstractFileDigester;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterException;

public class CRC32FileDigester
extends AbstractFileDigester {
    public static final String ALGORITHM = "CRC32";

    public CRC32FileDigester() {
        super(ALGORITHM);
    }

    @Override
    public String calculate(File file) throws DigesterException {
        CheckedInputStream cis;
        try {
            cis = new CheckedInputStream(new FileInputStream(file), new CRC32());
        }
        catch (FileNotFoundException e) {
            throw new DigesterException("Unable to read " + file.getPath() + ": " + e.getMessage());
        }
        byte[] buf = new byte[32768];
        try {
            while (cis.read(buf) >= 0) {
            }
        }
        catch (IOException e) {
            throw new DigesterException("Unable to calculate the " + this.getAlgorithm() + " hashcode for " + file.getPath() + ": " + e.getMessage());
        }
        return Long.toString(cis.getChecksum().getValue());
    }
}

