/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.NoSuchAlgorithmException;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactListener;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterFactory;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetInitializationException;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetWriteException;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;

public class OneHashPerFileTarget
implements ExecutionTarget {
    protected final String encoding;
    protected final File outputDirectory;
    protected final Iterable<? extends ArtifactListener> artifactListeners;
    protected boolean appendFilename = false;

    public OneHashPerFileTarget(String encoding, File outputDirectory, Iterable<? extends ArtifactListener> artifactListeners) {
        this.encoding = encoding;
        this.outputDirectory = outputDirectory;
        this.artifactListeners = artifactListeners;
    }

    public OneHashPerFileTarget(String encoding, File outputDirectory, Iterable<? extends ArtifactListener> artifactListeners, boolean appendFilename) {
        this.encoding = encoding;
        this.outputDirectory = outputDirectory;
        this.artifactListeners = artifactListeners;
        this.appendFilename = appendFilename;
    }

    public OneHashPerFileTarget(String encoding, Iterable<? extends ArtifactListener> artifactListeners) {
        this(encoding, null, artifactListeners);
    }

    @Override
    public void init() throws ExecutionTargetInitializationException {
        if (this.outputDirectory != null) {
            if (this.outputDirectory.exists() && !this.outputDirectory.isDirectory()) {
                throw new ExecutionTargetInitializationException("'" + this.outputDirectory.getPath() + "' already exists and is not a directory.");
            }
            this.outputDirectory.mkdirs();
        }
    }

    @Override
    public void write(String digest, ChecksumFile file, String algorithm) throws ExecutionTargetWriteException {
        try {
            File outputFileDirectory = this.outputDirectory != null ? this.outputDirectory : file.getFile().getParentFile();
            String fileExtension = DigesterFactory.getInstance().getFileDigester(algorithm).getFileExtension();
            String outputFileName = file.getFile().getName() + fileExtension;
            File outputFile = new File(outputFileDirectory.getPath(), outputFileName);
            StringBuilder digestToPrint = new StringBuilder(digest);
            if (this.appendFilename) {
                digestToPrint.append("  ");
                digestToPrint.append(file.getFile().getName());
            }
            Files.write(outputFile.toPath(), digestToPrint.toString().getBytes(this.encoding), StandardOpenOption.CREATE);
            for (ArtifactListener artifactListener : this.artifactListeners) {
                artifactListener.artifactCreated(outputFile, fileExtension, file.getExtension(), file.getClassifier());
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new ExecutionTargetWriteException(e.getMessage());
        }
    }

    @Override
    public void close(String subPath) {
    }
}

