/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.spring.boot.autoconfigure;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.config.ConfigClient;
import com.gitee.easyopen.interceptor.ApiInterceptor;
import com.gitee.easyopen.limit.ApiLimitConfigLocalManager;
import com.gitee.easyopen.limit.ApiLimitManager;
import com.gitee.easyopen.limit.LimitConfigManager;
import com.gitee.easyopen.limit.LimitManager;
import com.gitee.easyopen.spring.boot.autoconfigure.EasyopenProperties;
import com.gitee.easyopen.spring.boot.autoconfigure.PropertiesCopyAware;
import com.gitee.easyopen.support.ApiController;
import com.gitee.easyopen.util.CopyUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={EasyopenProperties.class})
public class EasyopenAutoConfiguration {
    private final EasyopenProperties properties;

    public EasyopenAutoConfiguration(EasyopenProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiConfig apiConfig() {
        return new ApiConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="easyopen", name={"cors"}, havingValue="true", matchIfMissing=true)
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", this.buildConfig());
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    @ConditionalOnMissingBean
    public CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        return corsConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean
    public PropertiesCopyAware defaultPropertiesCopyAware() {
        return new DefaultPropertiesCopyAware();
    }

    private static class DefaultPropertiesCopyAware
    implements PropertiesCopyAware {
        private DefaultPropertiesCopyAware() {
        }

        @Override
        public void copy(EasyopenProperties source, ApiConfig target) {
            CopyUtil.copyPropertiesIgnoreNull((Object)source, (Object)target, (String[])new String[0]);
        }
    }

    @Controller
    @RequestMapping(value={"api"})
    public class EayopenIndexController
    extends ApiController {
        @Autowired
        private ApiConfig config;
        @Autowired
        private PropertiesCopyAware propertiesCopyAware;

        protected void initApiConfig(ApiConfig apiConfig) {
            this.propertiesCopyAware.copy(EasyopenAutoConfiguration.this.properties, apiConfig);
            this.initInterceptor(EasyopenAutoConfiguration.this.properties, apiConfig);
            this.initOpenClient(EasyopenAutoConfiguration.this.properties, apiConfig);
        }

        private void initInterceptor(EasyopenProperties properties, ApiConfig apiConfig) {
            if (!CollectionUtils.isEmpty(properties.getInterceptors())) {
                List<String> interceptors = properties.getInterceptors();
                ApiInterceptor[] apiInterceptor = new ApiInterceptor[interceptors.size()];
                for (int i = 0; i < interceptors.size(); ++i) {
                    String interceptorClassName = interceptors.get(i);
                    try {
                        apiInterceptor[i] = (ApiInterceptor)Class.forName(interceptorClassName).newInstance();
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error("Class.forName({}).newInstance() error", (Object)interceptorClassName, (Object)e);
                        throw new RuntimeException(e);
                    }
                }
                apiConfig.setInterceptors(apiInterceptor);
            }
        }

        private void initOpenClient(EasyopenProperties properties, ApiConfig apiConfig) {
            String ip = properties.getConfigServerIp();
            String port = properties.getConfigServerPort();
            if (StringUtils.hasText((String)ip) && StringUtils.hasText((String)port)) {
                String docUrl = properties.getDocUrl();
                ConfigClient configClient = new ConfigClient(properties.getAppName(), ip, Integer.valueOf(port).intValue(), docUrl);
                if (properties.getConfigDistributedLimit().booleanValue()) {
                    RedisTemplate redisTemplate = (RedisTemplate)this.getApplicationContext().getBean("redisTemplate");
                    if (redisTemplate == null) {
                        throw new NullPointerException("redisTemplate\u4e0d\u80fd\u4e3anull\uff0c\u662f\u5426\u7f3a\u5c11spring-boot-starter-data-redis\u4f9d\u8d56");
                    }
                    configClient.setLimitManager((LimitManager)new ApiLimitManager(redisTemplate, (LimitConfigManager)new ApiLimitConfigLocalManager()));
                }
                apiConfig.setConfigClient(configClient);
            }
        }

        protected ApiConfig newApiConfig() {
            return this.config;
        }
    }
}

