/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.spring.boot.autoconfigure;

import com.gitee.easyopen.limit.LimitType;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="easyopen")
public class EasyopenProperties {
    public static final String EASYOPEN_PREFIX = "easyopen";
    private static final String DEFAULT_APP_NAME = "app";
    private static String CONFIG_FOLDER = System.getProperty("user.dir") + File.separator + "local-config" + File.separator;
    private Map<String, String> appSecret;
    private List<String> interceptors;
    private List<String> isvModules;
    private String appName;
    private String defaultVersion;
    private Integer timeoutSeconds;
    private Boolean showDoc;
    private String docPassword;
    private String docClassPath;
    private String docPdfClassPath;
    private String docPdfCssClassPath;
    private String monitorClassPath;
    private String loginClassPath;
    private String limitClassPath;
    private String limitPassword;
    private LimitType defaultLimitType;
    private Integer defaultLimitCount;
    private Integer defaultTokenBucketCount;
    private String localLimitConfigFile;
    private String localPermissionConfigFile;
    private String localSecretConfigFile;
    private Boolean ignoreValidate;
    private String oauth2LoginUri;
    private Long oauth2ExpireIn;
    private Integer jwtExpireIn;
    private String privateKey;
    private String priKeyPath;
    private Boolean showMonitor;
    private String monitorPassword;
    private Integer monitorErrorQueueSize;
    private Integer monitorExecutorSize;
    private String configServerIp;
    private String configServerPort;
    private String docUrl;
    private Boolean configDistributedLimit;
    private String markdownDocDir;
    private String cors;
    private String mono;
    private Boolean onlyJson = false;

    public EasyopenProperties() {
        this.setAppName(DEFAULT_APP_NAME);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
        this.localLimitConfigFile = System.getProperty("conflimit.file", CONFIG_FOLDER + appName + "-limit.json");
        this.localPermissionConfigFile = System.getProperty("confperm.file", CONFIG_FOLDER + appName + "-permission.json");
        this.localSecretConfigFile = System.getProperty("confsecret.file", CONFIG_FOLDER + appName + "-secret.json");
    }

    public Map<String, String> getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(Map<String, String> appSecret) {
        this.appSecret = appSecret;
    }

    public List<String> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<String> interceptors) {
        this.interceptors = interceptors;
    }

    public List<String> getIsvModules() {
        return this.isvModules;
    }

    public void setIsvModules(List<String> isvModules) {
        this.isvModules = isvModules;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Boolean getShowDoc() {
        return this.showDoc;
    }

    public void setShowDoc(Boolean showDoc) {
        this.showDoc = showDoc;
    }

    public String getDocPassword() {
        return this.docPassword;
    }

    public void setDocPassword(String docPassword) {
        this.docPassword = docPassword;
    }

    public String getDocClassPath() {
        return this.docClassPath;
    }

    public void setDocClassPath(String docClassPath) {
        this.docClassPath = docClassPath;
    }

    public String getDocPdfClassPath() {
        return this.docPdfClassPath;
    }

    public void setDocPdfClassPath(String docPdfClassPath) {
        this.docPdfClassPath = docPdfClassPath;
    }

    public String getDocPdfCssClassPath() {
        return this.docPdfCssClassPath;
    }

    public void setDocPdfCssClassPath(String docPdfCssClassPath) {
        this.docPdfCssClassPath = docPdfCssClassPath;
    }

    public String getMonitorClassPath() {
        return this.monitorClassPath;
    }

    public void setMonitorClassPath(String monitorClassPath) {
        this.monitorClassPath = monitorClassPath;
    }

    public String getLoginClassPath() {
        return this.loginClassPath;
    }

    public void setLoginClassPath(String loginClassPath) {
        this.loginClassPath = loginClassPath;
    }

    public String getLimitClassPath() {
        return this.limitClassPath;
    }

    public void setLimitClassPath(String limitClassPath) {
        this.limitClassPath = limitClassPath;
    }

    public String getLimitPassword() {
        return this.limitPassword;
    }

    public void setLimitPassword(String limitPassword) {
        this.limitPassword = limitPassword;
    }

    public LimitType getDefaultLimitType() {
        return this.defaultLimitType;
    }

    public void setDefaultLimitType(LimitType defaultLimitType) {
        this.defaultLimitType = defaultLimitType;
    }

    public Integer getDefaultLimitCount() {
        return this.defaultLimitCount;
    }

    public void setDefaultLimitCount(Integer defaultLimitCount) {
        this.defaultLimitCount = defaultLimitCount;
    }

    public Integer getDefaultTokenBucketCount() {
        return this.defaultTokenBucketCount;
    }

    public void setDefaultTokenBucketCount(Integer defaultTokenBucketCount) {
        this.defaultTokenBucketCount = defaultTokenBucketCount;
    }

    public String getLocalLimitConfigFile() {
        return this.localLimitConfigFile;
    }

    public void setLocalLimitConfigFile(String localLimitConfigFile) {
        this.localLimitConfigFile = localLimitConfigFile;
    }

    public String getLocalPermissionConfigFile() {
        return this.localPermissionConfigFile;
    }

    public void setLocalPermissionConfigFile(String localPermissionConfigFile) {
        this.localPermissionConfigFile = localPermissionConfigFile;
    }

    public String getLocalSecretConfigFile() {
        return this.localSecretConfigFile;
    }

    public void setLocalSecretConfigFile(String localSecretConfigFile) {
        this.localSecretConfigFile = localSecretConfigFile;
    }

    public Boolean getIgnoreValidate() {
        return this.ignoreValidate;
    }

    public void setIgnoreValidate(Boolean ignoreValidate) {
        this.ignoreValidate = ignoreValidate;
    }

    public String getOauth2LoginUri() {
        return this.oauth2LoginUri;
    }

    public void setOauth2LoginUri(String oauth2LoginUri) {
        this.oauth2LoginUri = oauth2LoginUri;
    }

    public Long getOauth2ExpireIn() {
        return this.oauth2ExpireIn;
    }

    public void setOauth2ExpireIn(Long oauth2ExpireIn) {
        this.oauth2ExpireIn = oauth2ExpireIn;
    }

    public Integer getJwtExpireIn() {
        return this.jwtExpireIn;
    }

    public void setJwtExpireIn(Integer jwtExpireIn) {
        this.jwtExpireIn = jwtExpireIn;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPriKeyPath() {
        return this.priKeyPath;
    }

    public void setPriKeyPath(String priKeyPath) {
        this.priKeyPath = priKeyPath;
    }

    public Boolean getShowMonitor() {
        return this.showMonitor;
    }

    public void setShowMonitor(Boolean showMonitor) {
        this.showMonitor = showMonitor;
    }

    public String getMonitorPassword() {
        return this.monitorPassword;
    }

    public void setMonitorPassword(String monitorPassword) {
        this.monitorPassword = monitorPassword;
    }

    public Integer getMonitorErrorQueueSize() {
        return this.monitorErrorQueueSize;
    }

    public void setMonitorErrorQueueSize(Integer monitorErrorQueueSize) {
        this.monitorErrorQueueSize = monitorErrorQueueSize;
    }

    public Integer getMonitorExecutorSize() {
        return this.monitorExecutorSize;
    }

    public void setMonitorExecutorSize(Integer monitorExecutorSize) {
        this.monitorExecutorSize = monitorExecutorSize;
    }

    public String getConfigServerIp() {
        return this.configServerIp;
    }

    public void setConfigServerIp(String configServerIp) {
        this.configServerIp = configServerIp;
    }

    public String getConfigServerPort() {
        return this.configServerPort;
    }

    public void setConfigServerPort(String configServerPort) {
        this.configServerPort = configServerPort;
    }

    public String getDocUrl() {
        return this.docUrl;
    }

    public void setDocUrl(String docUrl) {
        this.docUrl = docUrl;
    }

    public Boolean getConfigDistributedLimit() {
        return this.configDistributedLimit;
    }

    public void setConfigDistributedLimit(Boolean configDistributedLimit) {
        this.configDistributedLimit = configDistributedLimit;
    }

    public String getMarkdownDocDir() {
        return this.markdownDocDir;
    }

    public void setMarkdownDocDir(String markdownDocDir) {
        this.markdownDocDir = markdownDocDir;
    }

    public String getCors() {
        return this.cors;
    }

    public void setCors(String cors) {
        this.cors = cors;
    }

    public String getMono() {
        return this.mono;
    }

    public void setMono(String mono) {
        this.mono = mono;
    }

    public Boolean getOnlyJson() {
        return this.onlyJson;
    }

    public void setOnlyJson(Boolean onlyJson) {
        this.onlyJson = onlyJson;
    }
}

