/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.impsort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.revelc.code.impsort.Group;
import net.revelc.code.impsort.Import;

public final class Grouper {
    private final List<Group> groups;
    private final List<Group> staticGroups;
    private final boolean staticAfter;
    private final boolean joinStaticWithNonStatic;
    private final boolean breadthFirstStatic;
    static Comparator<Import> depthFirstComparator = (a, b) -> a.getImport().compareTo(b.getImport());
    static Comparator<Import> breadthFirstComparator = (a, b) -> {
        String secondContainingClass;
        String first = a.getImport();
        String second = b.getImport();
        int firstLastDot = first.lastIndexOf(".");
        int secondLastDot = second.lastIndexOf(".");
        String firstContainingClass = first.substring(0, firstLastDot);
        int comparison = firstContainingClass.compareTo(secondContainingClass = second.substring(0, secondLastDot));
        if (comparison == 0) {
            comparison = first.substring(firstLastDot).compareTo(second.substring(secondLastDot));
        }
        return comparison;
    };

    public Grouper(String groups, String staticGroups, boolean staticAfter, boolean joinStaticWithNonStatic, boolean breadthFirstStatic) {
        this.groups = Collections.unmodifiableList(Grouper.parse(groups));
        this.staticGroups = Grouper.parse(staticGroups);
        this.staticAfter = staticAfter;
        this.joinStaticWithNonStatic = joinStaticWithNonStatic;
        this.breadthFirstStatic = breadthFirstStatic;
    }

    static ArrayList<Group> parse(String groups) {
        ArrayList<Group> parsedGroups = new ArrayList<Group>();
        String[] array = Objects.requireNonNull(groups).replaceAll("\\s+", "").split(",");
        Pattern validGroup = Pattern.compile("^(?:\\w+(?:[.]\\w+)*[.]?|[*])$");
        if (array.length != 1 || !array[0].isEmpty()) {
            for (String g : array) {
                if (!validGroup.matcher(g).matches()) {
                    throw new IllegalArgumentException("Invalid group (" + g + ") in (" + groups + ")");
                }
                if (parsedGroups.stream().anyMatch(o -> g.contentEquals(o.getPrefix()))) {
                    throw new IllegalArgumentException("Duplicate group (" + g + ") in (" + groups + ")");
                }
                int encounterOrder = parsedGroups.size();
                parsedGroups.add(new Group(g, encounterOrder));
            }
        }
        if (parsedGroups.stream().noneMatch(o -> "*".contentEquals(o.getPrefix()))) {
            parsedGroups.add(new Group("*", parsedGroups.size()));
        }
        parsedGroups.sort((a, b) -> {
            int comp = Integer.compare(b.getPrefix().length(), a.getPrefix().length());
            return comp != 0 ? comp : Integer.compare(a.getOrder(), a.getOrder());
        });
        return parsedGroups;
    }

    public Map<Integer, ArrayList<Import>> groupNonStatic(Collection<Import> allImports) {
        return Grouper.group(allImports, this.groups, i -> !i.isStatic(), depthFirstComparator);
    }

    public Map<Integer, ArrayList<Import>> groupStatic(Collection<Import> allImports) {
        return Grouper.group(allImports, this.staticGroups, i -> i.isStatic(), this.breadthFirstStatic ? breadthFirstComparator : depthFirstComparator);
    }

    private static Map<Integer, ArrayList<Import>> group(Collection<Import> allImports, List<Group> groups, Predicate<Import> filter, Comparator<Import> itemComparator) {
        TreeMap<Integer, ArrayList<Import>> map = new TreeMap<Integer, ArrayList<Import>>();
        allImports.stream().filter(filter).forEach(imp -> {
            for (Group group : groups) {
                if (!group.matches(imp.getImport())) continue;
                map.computeIfAbsent(group.getOrder(), x -> new ArrayList()).add(imp);
                break;
            }
        });
        for (ArrayList list : map.values()) {
            list.sort(itemComparator);
        }
        return map;
    }

    public boolean getStaticAfter() {
        return this.staticAfter;
    }

    public boolean getJoinStaticWithNonStatic() {
        return this.joinStaticWithNonStatic;
    }

    public String groupedImports(Collection<Import> allImports, String eol) {
        StringBuilder sb = new StringBuilder();
        Map<Integer, ArrayList<Import>> staticImports = this.groupStatic(allImports);
        Map<Integer, ArrayList<Import>> nonStaticImports = this.groupNonStatic(allImports);
        Map<Integer, ArrayList<Import>> first = this.getStaticAfter() ? nonStaticImports : staticImports;
        Map<Integer, ArrayList<Import>> second = this.getStaticAfter() ? staticImports : nonStaticImports;
        AtomicBoolean firstGroup = new AtomicBoolean(true);
        Consumer<ArrayList> consumer = grouping -> {
            if (!firstGroup.getAndSet(false)) {
                sb.append(eol);
            }
            grouping.forEach(imp -> sb.append(imp).append(eol));
        };
        first.values().forEach(consumer);
        if (!(this.getJoinStaticWithNonStatic() || first.isEmpty() || second.isEmpty())) {
            sb.append(eol);
        }
        firstGroup.set(true);
        second.values().forEach(consumer);
        return sb.toString();
    }
}

