/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nsidita.BlankRemover;
import com.nexwave.nsidita.DocFileInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxDocFileParser
extends DefaultHandler {
    protected DocFileInfo fileDesc = null;
    protected String projectDir = null;
    protected StringBuffer strbf = null;
    private String currentElName = "";
    private StringBuffer tempVal = null;
    private boolean shortdescBool = false;
    private int shortTagCpt = 0;
    private boolean addContent = false;
    private boolean addHeaderInfo = false;
    private boolean doNotIndex = false;
    private int divCount = 0;

    public int init(String inputDir) {
        return 0;
    }

    public DocFileInfo runExtractData(File file) {
        this.fileDesc = new DocFileInfo(file);
        this.strbf = new StringBuffer("");
        this.parseDocument(file);
        return this.fileDesc;
    }

    public void parseDocument(File file) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        this.addContent = false;
        this.divCount = 0;
        try {
            SAXParser sp = spf.newSAXParser();
            sp.getXMLReader().setFeature("http://xml.org/sax/features/external-general-entities", false);
            sp.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            System.out.println("Parsing: " + file);
            long start = System.currentTimeMillis();
            String content = this.RemoveValidationPI(file);
            if (content != null) {
                InputSource is = new InputSource(new StringReader(content));
                is.setSystemId(file.toURI().toURL().toString());
                sp.parse(is, (DefaultHandler)this);
            }
            long finish = System.currentTimeMillis();
        }
        catch (SAXParseException spe) {
            System.out.println("SaxParseException: The indexing file contains incorrect xml syntax.");
            spe.printStackTrace();
        }
        catch (SAXException se) {
            System.out.println("SaxException. You may need to include Xerces in your classpath. See documentation for details");
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentElName = qName;
        if (qName.equalsIgnoreCase("meta")) {
            this.addHeaderInfo = true;
            String attrName = attributes.getValue("name");
            if (attrName != null && (attrName.equalsIgnoreCase("keywords") || attrName.equalsIgnoreCase("description"))) {
                this.strbf.append(" " + attributes.getValue("content") + " ");
            }
            if (attrName != null && attrName.equalsIgnoreCase("description")) {
                this.fileDesc.setShortdesc(BlankRemover.rmWhiteSpace(attributes.getValue("content").replace('\n', ' ')));
            }
        }
        if (qName.equalsIgnoreCase("title") || qName.equalsIgnoreCase("shortdesc")) {
            this.tempVal = new StringBuffer();
        }
        this.addHeaderInfo = qName.equalsIgnoreCase("meta") || qName.equalsIgnoreCase("title") || qName.equalsIgnoreCase("shortdesc");
        String elementId = attributes.getValue("id");
        if ("content".equals(elementId)) {
            this.addContent = true;
        }
        if (this.addContent) {
            String accessKey;
            if (qName.equalsIgnoreCase("div")) {
                ++this.divCount;
            }
            if (qName.equalsIgnoreCase("div") || qName.equalsIgnoreCase("p") || qName.equalsIgnoreCase("span")) {
                String stemp = attributes.getValue("class");
                if (stemp != null && (stemp.equalsIgnoreCase("shortdesc") || stemp.equalsIgnoreCase("summary"))) {
                    this.shortdescBool = true;
                }
                this.tempVal = new StringBuffer();
                this.strbf.append(" ");
            }
            if (this.shortdescBool) {
                ++this.shortTagCpt;
            }
            this.doNotIndex = (accessKey = attributes.getValue("accesskey")) != null && ("n".equals(accessKey) || "p".equals(accessKey) || "h".equals(accessKey));
        }
        this.strbf.append(" ");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if ((this.addContent || this.addHeaderInfo) && !this.doNotIndex && !this.currentElName.equalsIgnoreCase("script")) {
            String text = new String(ch, start, length);
            this.strbf.append(text);
            if (this.tempVal != null) {
                this.tempVal.append(text);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("title")) {
            this.fileDesc.setTitle(BlankRemover.rmWhiteSpace(this.tempVal.toString()));
            this.tempVal = null;
        } else if (this.shortdescBool) {
            --this.shortTagCpt;
            if (this.shortTagCpt == 0) {
                this.fileDesc.setShortdesc(BlankRemover.rmWhiteSpace(this.tempVal.toString().replace('\n', ' ')));
                this.tempVal = null;
                this.shortdescBool = false;
            }
        }
        if (qName.equalsIgnoreCase("div") && this.addContent) {
            --this.divCount;
            if (this.divCount == 0) {
                this.addContent = false;
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return null;
    }

    public String RemoveValidationPI(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while (true) {
                boolean ok = true;
                try {
                    String line = br.readLine();
                    if (line == null) break;
                    if (!(line = line.replaceAll("\\x26nbsp\\x3B", "&#160;")).contains("<!DOCTYPE html PUBLIC")) {
                        if (line.contains("<?xml version")) {
                            line = line.replaceAll("\\x3C\\x3Fxml[^\\x3E]*\\x3F\\x3E", "\n");
                        }
                        sb.append(line + "\n");
                        continue;
                    }
                    int i1 = line.indexOf("<!DOCTYPE");
                    int i2 = line.indexOf(">", i1);
                    while (i2 < 0) {
                        line = line.concat(br.readLine());
                        i2 = line.indexOf(">", i1);
                    }
                    String temp = line.substring(i1, i2);
                    if (line.contains("<?xml version")) {
                        line = line.replaceAll("\\x3C\\x3Fxml[^\\x3E]*\\x3F\\x3E", "\n");
                    }
                    line = line.replaceAll("\\x3C\\x21DOCTYPE[^\\x3E]*\\x3E", "\n");
                    sb.append(line);
                }
                catch (IOException e) {
                    break;
                }
            }
            br.close();
        }
        catch (IOException e) {
            return null;
        }
        return sb.toString();
    }
}

