/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;

public class Component {
    protected Actor actor;
    private Visibility visibility;
    private List<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
    private StylesheetPackage containingPackage;
    private StylesheetPackage declaringPackage;
    private boolean hasExplicitVisibility;
    private Component baseComponent;

    private Component() {
    }

    public static Component makeComponent(Actor actor, Visibility visibility, StylesheetPackage containingPackage, StylesheetPackage declaringPackage) {
        Component c = actor instanceof Mode ? new M() : new Component();
        c.actor = actor;
        c.visibility = visibility;
        c.hasExplicitVisibility = visibility != null;
        c.containingPackage = containingPackage;
        c.declaringPackage = declaringPackage;
        return c;
    }

    public List<ComponentBinding> getComponentBindings() {
        return this.bindings;
    }

    public void setComponentBindings(List<ComponentBinding> bindings) {
        this.bindings = bindings;
    }

    public void setVisibility(Visibility visibility, boolean explicit) {
        this.visibility = visibility;
        this.hasExplicitVisibility = explicit;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isVisibilityExplicit() {
        return this.hasExplicitVisibility;
    }

    public boolean isHiddenAbstractComponent() {
        return this.visibility == Visibility.HIDDEN && this.baseComponent != null && this.baseComponent.getVisibility() == Visibility.ABSTRACT;
    }

    public Actor getActor() {
        return this.actor;
    }

    public StylesheetPackage getDeclaringPackage() {
        return this.declaringPackage;
    }

    public StylesheetPackage getContainingPackage() {
        return this.containingPackage;
    }

    public Component getBaseComponent() {
        return this.baseComponent;
    }

    public void setBaseComponent(Component original) {
        this.baseComponent = original;
    }

    public void export(ExpressionPresenter out, Map<Component, Integer> componentIdMap, Map<StylesheetPackage, Integer> packageIdMap) throws XPathException {
        out.startElement("co");
        int id = this.obtainComponentId(this, componentIdMap);
        out.emitAttribute("id", "" + id);
        if (this.getVisibility() != null && (this.hasExplicitVisibility || this.getVisibility() != Visibility.PRIVATE)) {
            out.emitAttribute("vis", this.getVisibility().toString());
        }
        String refs = this.listComponentReferences(componentIdMap);
        out.emitAttribute("binds", refs);
        if (this.baseComponent != null && this.getActor() == this.baseComponent.getActor()) {
            int baseId = this.obtainComponentId(this.baseComponent, componentIdMap);
            out.emitAttribute("base", "" + baseId);
            out.emitAttribute("dpack", packageIdMap.get(this.declaringPackage) + "");
        } else {
            this.actor.export(out);
        }
        out.endElement();
    }

    public String listComponentReferences(Map<Component, Integer> componentIdMap) {
        FastStringBuffer fsb = new FastStringBuffer(128);
        for (ComponentBinding ref : this.getComponentBindings()) {
            Component target = ref.getTarget();
            int targetId = this.obtainComponentId(target, componentIdMap);
            if (fsb.length() != 0) {
                fsb.append(" ");
            }
            fsb.append("" + targetId);
        }
        return fsb.toString();
    }

    private int obtainComponentId(Component component, Map<Component, Integer> componentIdMap) {
        Integer id = componentIdMap.get(component);
        if (id == null) {
            id = componentIdMap.size();
            componentIdMap.put(component, id);
        }
        return id;
    }

    public static class M
    extends Component {
        @Override
        public Mode getActor() {
            return (Mode)super.getActor();
        }

        public void setActor(Mode m) {
            this.actor = m;
        }
    }
}

