/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class ItemMappingIterator<F extends Item<?>, T extends Item<?>>
implements SequenceIterator<T>,
LookaheadIterator<T>,
LastPositionFinder {
    private SequenceIterator<? extends F> base;
    private ItemMappingFunction<F, T> action;
    private boolean oneToOne = false;

    public ItemMappingIterator(SequenceIterator<F> base, ItemMappingFunction<F, T> action) {
        this.base = base;
        this.action = action;
    }

    public ItemMappingIterator(SequenceIterator<? extends F> base, ItemMappingFunction<F, T> action, boolean oneToOne) {
        this.base = base;
        this.action = action;
        this.oneToOne = oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    protected SequenceIterator<? extends F> getBaseIterator() {
        return this.base;
    }

    protected ItemMappingFunction<F, T> getMappingFunction() {
        return this.action;
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    @Override
    public T next() throws XPathException {
        F nextSource;
        T current;
        do {
            if ((nextSource = this.base.next()) != null) continue;
            return null;
        } while ((current = this.action.mapItem(nextSource)) == null);
        return current;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public int getLength() throws XPathException {
        return ((LastPositionFinder)((Object)this.base)).getLength();
    }

    @Override
    public int getProperties() {
        if (this.oneToOne) {
            return this.base.getProperties() & 6;
        }
        return 0;
    }
}

