/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import net.shibboleth.ext.spring.config.StringToResourceConverter;
import net.shibboleth.utilities.java.support.resource.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class StringToResourceTest {
    private final StringToResourceConverter converter = new StringToResourceConverter();
    private String path;

    @BeforeClass
    public void setup() throws IOException {
        File file = File.createTempFile("TEST", "convert");
        file.createNewFile();
        file.deleteOnExit();
        Assert.assertTrue((boolean)file.exists());
        this.path = file.getAbsolutePath();
    }

    @Test
    public void exists() {
        Resource r = this.converter.convert(this.path);
        Assert.assertTrue((boolean)r.exists());
    }

    @Test
    public void notExist() {
        Resource r = this.converter.convert(this.path + "x");
        Assert.assertFalse((boolean)r.exists());
    }

    @Test
    public void endsWithSpace() {
        try {
            Resource r = this.converter.convert(this.path + " ");
            Assert.assertFalse((boolean)r.exists());
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
    }
}

