/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.config;

import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class NonReloadableExcluder
implements BeanFactoryPostProcessor {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NonReloadableExcluder.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            if (beanDef.getScope() != null && "reloadable".equals(beanDef.getScope())) {
                this.log.debug("Converting reloadable bean '{}' into singleton", (Object)beanName);
                beanDef.setScope("singleton");
                continue;
            }
            this.log.debug("Hiding non-reloadable bean '{}' as a lazy-init", (Object)beanName);
            beanDef.setLazyInit(true);
        }
    }
}

