/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import net.shibboleth.ext.spring.resource.HTTPResource;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FileBackedHTTPResource
extends HTTPResource {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FileBackedHTTPResource.class);
    @Nonnull
    private final Resource backingResource;

    public FileBackedHTTPResource(@Nonnull @ParameterName(name="backingFile") String backingFile, @Nonnull @ParameterName(name="client") HttpClient client, @Nonnull @ParameterName(name="url") @NotEmpty String url) throws IOException {
        super(client, url);
        Constraint.isNotNull((Object)backingFile, (String)"File Name must not be null");
        File file = new File(backingFile);
        this.backingResource = new FileSystemResource(file);
    }

    public FileBackedHTTPResource(@Nonnull @ParameterName(name="backingFile") String backingFile, @Nonnull @ParameterName(name="client") HttpClient client, @Nonnull @ParameterName(name="url") URL url) throws IOException {
        super(client, url);
        Constraint.isNotNull((Object)backingFile, (String)"File Name must not be null");
        File file = new File(backingFile);
        this.backingResource = new FileSystemResource(file);
    }

    protected InputStream saveAndClone(InputStream input) throws IOException {
        try (FileOutputStream out = new FileOutputStream(this.backingResource.getFile());){
            this.log.debug("{}: Copying file.", (Object)this.getDescription());
            ByteStreams.copy((InputStream)input, (OutputStream)out);
            this.log.debug("{}: Copy done.", (Object)this.getDescription());
        }
        catch (IOException e) {
            this.backingResource.getFile().delete();
            this.log.error("{}: Copy failed: {}", (Object)this.getDescription(), (Object)e.getMessage());
            throw e;
        }
        return new FileInputStream(this.backingResource.getFile());
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream;
        block10: {
            InputStream stream = super.getInputStream();
            try {
                inputStream = this.saveAndClone(stream);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    this.log.debug("{} Error obtaining HTTPResource InputStream or creating backing file", (Object)this.getDescription(), (Object)ex);
                    this.log.warn("{} HTTP resource was inaccessible for getInputStream(), trying backing file.", (Object)this.getDescription());
                    try {
                        return new FileInputStream(this.backingResource.getFile());
                    }
                    catch (IOException e) {
                        this.log.error("FileBackedHTTPResource {}: Could not read backing file: {}", (Object)this.getDescription(), (Object)e.getMessage());
                        throw e;
                    }
                }
            }
            stream.close();
        }
        return inputStream;
    }

    @Override
    public boolean exists() {
        HttpResponse response;
        this.log.debug("{}: Attempting to fetch HTTP resource", (Object)this.getDescription());
        try {
            response = this.getResourceHeaders();
        }
        catch (IOException e) {
            this.log.info("{}: Could not reach URL, trying file", (Object)this.getDescription(), (Object)e);
            return this.backingResource.exists();
        }
        int httpStatusCode = response.getStatusLine().getStatusCode();
        if (httpStatusCode == 200) {
            return true;
        }
        return this.backingResource.exists();
    }

    @Override
    public long contentLength() throws IOException {
        try {
            return super.contentLength();
        }
        catch (IOException e) {
            this.log.info("{}: Could not reach URL, trying file", (Object)this.getDescription(), (Object)e);
            return this.backingResource.contentLength();
        }
    }

    @Override
    public long lastModified() throws IOException {
        try {
            return super.lastModified();
        }
        catch (IOException e) {
            this.log.info("{}: Could not reach URL, trying file", (Object)this.getDescription(), (Object)e);
            return this.backingResource.lastModified();
        }
    }

    @Override
    public HTTPResource createRelative(String relativePath) throws IOException {
        this.log.warn("{}: Relative resources are not file backed");
        return super.createRelative(relativePath);
    }

    @Override
    public String getDescription() {
        String urlAsString;
        try {
            urlAsString = this.getURL().toString();
        }
        catch (IOException e) {
            urlAsString = "<unknown>";
        }
        StringBuilder builder = new StringBuilder("FileBackedHTTPResource [").append(urlAsString).append('|').append(this.backingResource.getDescription()).append(']');
        return builder.toString();
    }
}

