/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.service;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.springframework.context.ApplicationContext;

public class ClassBasedServiceStrategy<T>
implements Function<ApplicationContext, ServiceableComponent<T>> {
    @Nonnull
    private final Class<ServiceableComponent> serviceClaz;

    public ClassBasedServiceStrategy() {
        this.serviceClaz = ServiceableComponent.class;
    }

    public ClassBasedServiceStrategy(@ParameterName(name="serviceableClaz") Class<ServiceableComponent> serviceableClaz) {
        this.serviceClaz = (Class)Constraint.isNotNull(serviceableClaz, (String)"Serviceable Class cannot be null");
    }

    @Override
    @Nullable
    public ServiceableComponent<T> apply(@Nullable ApplicationContext appContext) {
        Collection components = appContext.getBeansOfType(this.serviceClaz).values();
        if (components.size() == 0) {
            throw new ServiceException("Reload did not produce any bean of type " + this.serviceClaz.getName());
        }
        if (components.size() > 1) {
            throw new ServiceException("Reload produced " + components.size() + " ServiceableComponents");
        }
        return (ServiceableComponent)components.iterator().next();
    }
}

