/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Deprecated(forRemoval=true, since="6.1.0")
public abstract class AbstractSpringExpressionEvaluator<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSpringExpressionEvaluator.class);
    @Nullable
    private String springExpression;
    @Nullable
    private Object customObject;
    @Nullable
    private Class<U> outputType;
    @Nullable
    private Class<T> inputType;
    private boolean hideExceptions;
    @Nullable
    private U returnOnError;

    public AbstractSpringExpressionEvaluator(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        this.springExpression = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)expression), (String)"Expression cannot be null or empty");
    }

    public void setOutputType(@Nullable Class<U> type) {
        this.outputType = type;
    }

    @Nullable
    protected Class<U> getOutputType() {
        return this.outputType;
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputType;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputType = type;
    }

    public void setCustomObject(@Nullable Object object) {
        this.customObject = object;
    }

    public Object getCustomObject() {
        return this.customObject;
    }

    public void setHideExceptions(boolean flag) {
        this.hideExceptions = flag;
    }

    public void setReturnOnError(U what) {
        this.returnOnError = what;
    }

    protected U evaluate(@Nullable T input) {
        if (null != input && null != this.getInputType() && !this.getInputType().isInstance(input)) {
            this.log.error("Input was type {} which is not an instance of {}", input.getClass(), this.getInputType());
            throw new ClassCastException("Input was type " + input.getClass() + " which is not an instance of " + this.getInputType());
        }
        try {
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("custom", this.customObject);
            context.setVariable("input", input);
            this.prepareContext((EvaluationContext)context, input);
            Object output = parser.parseExpression(this.springExpression).getValue((EvaluationContext)context);
            if (output == null) {
                return null;
            }
            if (null != this.getOutputType()) {
                if (!this.getOutputType().isInstance(output)) {
                    this.log.error("Output of type {} was not of type {}", output.getClass(), this.getOutputType());
                    return this.returnOnError;
                }
                return this.getOutputType().cast(output);
            }
            return (U)output;
        }
        catch (Exception e) {
            this.log.error("Error evaluating Spring expression", (Throwable)e);
            if (this.hideExceptions) {
                return this.returnOnError;
            }
            throw e;
        }
    }

    protected void prepareContext(@Nonnull EvaluationContext context, @Nullable T input) {
    }
}

