/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.util.HashMap;
import java.util.Iterator;
import net.shibboleth.ext.spring.util.SpringExpressionFunction;
import net.shibboleth.ext.spring.util.SpringExpressionPredicate;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpringExpressionTest {
    public int getValue99() {
        return 99;
    }

    @Test
    public void testPredicates() {
        SpringExpressionPredicate predicate = new SpringExpressionPredicate("#input.getValue99() == 99");
        predicate.setInputType(SpringExpressionTest.class);
        Assert.assertTrue((boolean)predicate.test((Object)this));
        predicate = new SpringExpressionPredicate("#input.getValue99() == #custom");
        predicate.setCustomObject((Object)99);
        Assert.assertTrue((boolean)predicate.test((Object)this));
    }

    @Test
    public void testFunction() {
        SpringExpressionFunction func = new SpringExpressionFunction("#input");
        func.setOutputType(SpringExpressionTest.class);
        Assert.assertNull((Object)func.apply(null));
        Assert.assertEquals((Object)func.apply((Object)this), (Object)this);
        Assert.assertEquals((int)((Integer)new SpringExpressionFunction("#input.getValue99()").apply((Object)this)), (int)99);
    }

    @Test
    public void idp1901Canary() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        Iterator iter = map.entrySet().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Boolean output = (Boolean)new SpelExpressionParser().parseExpression("hasNext()").getValue(iter, Boolean.class);
        Assert.assertNotNull((Object)output);
        Assert.assertTrue((boolean)output);
    }
}

