/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.cli;

import com.beust.jcommander.JCommander;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.cli.CommandLineArguments;
import net.shibboleth.ext.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.ext.spring.resource.PreferFileSystemResourceLoader;
import net.shibboleth.ext.spring.util.ApplicationContextBuilder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;

public abstract class AbstractCommandLine<T extends CommandLineArguments> {
    @Nonnull
    @NotEmpty
    public static final String ARGS_PROPERTY = "net.shibboleth.ext.spring.cli.arguments";
    public static final int RC_OK = 0;
    public static final int RC_INIT = 1;
    public static final int RC_IO = 2;
    public static final int RC_UNKNOWN = -1;
    @Nullable
    private GenericApplicationContext applicationContext;
    @Nullable
    private ApplicationContextInitializer<? super FilesystemGenericApplicationContext> contextInitializer;

    protected void setContextInitializer(@Nonnull ApplicationContextInitializer<? super FilesystemGenericApplicationContext> initializer) {
        this.contextInitializer = (ApplicationContextInitializer)Constraint.isNotNull(initializer, (String)"Injected ContextInitializer cannot be null");
    }

    @Nonnull
    protected GenericApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("No application context installed");
        }
        return this.applicationContext;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    protected List<Resource> getAdditionalSpringResources() {
        return Collections.emptyList();
    }

    protected int run(@Nonnull String[] args) {
        CommandLineArguments argObject;
        try {
            Constructor<T> construct = this.getArgumentClass().getConstructor(new Class[0]);
            argObject = (CommandLineArguments)construct.newInstance(new Object[0]);
            JCommander jc = new JCommander((Object)argObject);
            jc.parse(args);
            if (argObject.isHelp()) {
                argObject.printHelp(System.out);
                return 0;
            }
            if (argObject.isVersion()) {
                System.out.println(this.getVersion());
                return 0;
            }
            this.initLogging(argObject);
            argObject.validate();
        }
        catch (Exception e) {
            AbstractCommandLine.error(e.getMessage());
            return 1;
        }
        return this.doRun(argObject);
    }

    private void setLoggingProperty(@Nonnull String value) {
        System.setProperty("logback.configurationFile", value);
    }

    private void setLoggingToLocalResource(@Nonnull String value) {
        this.setLoggingProperty("net/shibboleth/ext/spring/cli/" + value);
    }

    protected void initLogging(@Nonnull T args) {
        if (args.getLoggingConfiguration() != null) {
            this.setLoggingProperty(args.getLoggingConfiguration());
        } else if (args.isVerboseOutput()) {
            this.setLoggingToLocalResource("logger-verbose.xml");
        } else if (args.isQuietOutput()) {
            this.setLoggingToLocalResource("logger-quiet.xml");
        } else {
            this.setLoggingToLocalResource("logger-normal.xml");
        }
    }

    protected int doRun(@Nonnull T args) {
        try {
            PreferFileSystemResourceLoader loader = new PreferFileSystemResourceLoader();
            List<Resource> additionalConfigs = this.getAdditionalSpringResources();
            ArrayList<Resource> configs = new ArrayList<Resource>(1 + additionalConfigs.size());
            if (args.getOtherArgs().size() > 0) {
                configs.add(loader.getResource(args.getOtherArgs().get(0)));
            }
            configs.addAll(additionalConfigs);
            this.getLogger().debug("Initializing Spring context with {}", configs);
            List<Resource> resources = args.getPropertyFiles().stream().map(arg_0 -> ((ResourceLoader)loader).getResource(arg_0)).collect(Collectors.toUnmodifiableList());
            ArrayList propertySources = new ArrayList(resources.size());
            resources.forEach(r -> {
                try {
                    propertySources.add((PropertySource<?>)new ResourcePropertySource(r));
                }
                catch (IOException e) {
                    if (args.isVerboseOutput()) {
                        this.getLogger().error("Unable to load properties from {}", r, (Object)e);
                    }
                    this.getLogger().error("Unable to load properties from {}", r, (Object)e.getMessage());
                }
            });
            ApplicationContextBuilder builder = new ApplicationContextBuilder().setServiceConfigurations(configs).setPropertySources(propertySources);
            if (this.contextInitializer != null) {
                builder.setContextInitializer(this.contextInitializer);
            }
            this.applicationContext = builder.build();
            this.applicationContext.registerShutdownHook();
        }
        catch (Exception e) {
            if (args.isVerboseOutput()) {
                this.getLogger().error("Unable to initialize Spring context", (Throwable)e);
            } else {
                this.getLogger().error("Unable to initialize Spring context", (Object)e.getMessage());
            }
            return 1;
        }
        return 0;
    }

    @Nonnull
    protected abstract Class<T> getArgumentClass();

    @Nonnull
    @NotEmpty
    protected abstract String getVersion();

    @Nonnull
    protected abstract Logger getLogger();

    private static void error(@Nonnull @NotEmpty String error) {
        System.err.println(error);
        System.err.flush();
        System.out.println();
        System.out.flush();
    }

    public static enum TerminalCodes {
        RESET("\u001b[0m"),
        BLACK("\u001b[30m"),
        RED("\u001b[31m"),
        GREEN("\u001b[32m"),
        YELLOW("\u001b[33m"),
        BLUE("\u001b[34m"),
        PURPLE("\u001b[35m"),
        CYAN("\u001b[36m"),
        WHITE("\u001b[37m");

        @Nonnull
        @NotEmpty
        private final String ansicode;

        private TerminalCodes(String ansi) {
            this.ansicode = ansi;
        }

        public String code(@Nonnull CommandLineArguments args) {
            return args.isANSI() ? this.ansicode : "";
        }
    }
}

