/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.util.AbstractSpringExpressionEvaluatorEx;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;

public class SpringExpressionBiFunction<T, U, V>
extends AbstractSpringExpressionEvaluatorEx
implements BiFunction<T, U, V> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionBiFunction.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    public SpringExpressionBiFunction(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        super(expression);
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    @Override
    public void setOutputType(@Nullable Class<?> type) {
        super.setOutputType(type);
    }

    @Override
    public void setReturnOnError(@Nullable Object value) {
        super.setReturnOnError(value);
    }

    @Override
    @Nullable
    public V apply(@Nullable T first, @Nullable U second) {
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            if (null != first && !((Class)types.getFirst()).isInstance(first)) {
                this.log.error("Input of type {} was not of type {}", first.getClass(), types.getFirst());
                return (V)this.getReturnOnError();
            }
            if (null != second && !((Class)types.getSecond()).isInstance(second)) {
                this.log.error("Input of type {} was not of type {}", second.getClass(), types.getSecond());
                return (V)this.getReturnOnError();
            }
        }
        return (V)this.evaluate(first, second);
    }

    @Override
    protected void prepareContext(@Nonnull EvaluationContext context, Object ... input) {
        context.setVariable("input1", input[0]);
        context.setVariable("input2", input[1]);
    }
}

