/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.util.AbstractSpringExpressionEvaluatorEx;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;

public class SpringExpressionPredicate<T>
extends AbstractSpringExpressionEvaluatorEx
implements Predicate<T> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionPredicate.class);
    @Nullable
    private Class<T> inputTypeClass;

    public SpringExpressionPredicate(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        super(expression);
        this.setOutputType(Boolean.class);
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputTypeClass;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputTypeClass = type;
    }

    public void setReturnOnError(boolean flag) {
        super.setReturnOnError(flag);
    }

    public boolean test(@Nullable T input) {
        if (null != this.getInputType() && null != input && !this.getInputType().isInstance(input)) {
            this.log.error("Input of type {} was not of type {}", input.getClass(), this.getInputType());
            return (Boolean)this.getReturnOnError();
        }
        Object result = this.evaluate(input);
        return (Boolean)(result != null ? result : this.getReturnOnError());
    }

    @Override
    protected void prepareContext(@Nonnull EvaluationContext context, Object ... input) {
        context.setVariable("input", input[0]);
    }
}

