/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MapTest {
    private static final String KEY_1 = "StringOne";
    private static final String KEY_2 = "StringTwo";
    private static final String KEY_3 = "StringThree";
    private static final Object VALUE_1 = new Object();
    private static final Object VALUE_2 = "Value2";
    private static final Integer INTEGER_3 = 2;
    private static final Object VALUE_3 = INTEGER_3;

    public static void testMap(Map<String, Object> map) {
        Assert.assertTrue((boolean)map.isEmpty(), (String)"Initially map must be empty");
        Assert.assertEquals((int)map.values().size(), (int)0, (String)"Zero Keys, zero values");
        Assert.assertEquals((int)map.keySet().size(), (int)0, (String)"Zero Keys, zero values");
        Assert.assertEquals((int)map.entrySet().size(), (int)0, (String)"Zero Keys, zero values");
        Assert.assertNull((Object)map.put(KEY_1, VALUE_1), (String)"Initial result of put should be null");
        Assert.assertEquals((int)map.size(), (int)1, (String)"One element expected");
        Assert.assertTrue((boolean)map.containsKey(KEY_1), (String)"Contains key StringOne");
        Assert.assertFalse((boolean)map.containsKey(VALUE_1), (String)"Contains key StringOne");
        Assert.assertFalse((boolean)map.containsKey(KEY_3), (String)"Contains key StringThree");
        Assert.assertTrue((boolean)map.containsValue(VALUE_1), (String)("Contains value " + VALUE_1));
        Assert.assertFalse((boolean)map.containsValue(KEY_1), (String)"Contains value StringOne");
        Assert.assertEquals((Object)map.put(KEY_1, VALUE_1), (Object)VALUE_1, (String)"Duplicate put");
        Assert.assertEquals((int)map.size(), (int)1, (String)"One element expected");
        Assert.assertTrue((boolean)map.containsKey(KEY_1), (String)"Contains key StringOne");
        Assert.assertFalse((boolean)map.containsKey(KEY_3), (String)"Contains key StringThree");
        Assert.assertTrue((boolean)map.containsValue(VALUE_1), (String)("Contains value " + VALUE_1));
        Assert.assertEquals((Object)map.put(KEY_1, VALUE_2), (Object)VALUE_1, (String)"Duplicate put");
        Assert.assertEquals((int)map.size(), (int)1, (String)"One element expected");
        Assert.assertEquals((int)map.values().size(), (int)1, (String)"One Keys, one value");
        Assert.assertEquals((int)map.keySet().size(), (int)1, (String)"One Keys, one value");
        Assert.assertEquals((int)map.entrySet().size(), (int)1, (String)"One Keys, one value");
        Assert.assertTrue((boolean)map.containsKey(KEY_1), (String)"Contains key StringOne");
        Assert.assertFalse((boolean)map.containsKey(KEY_3), (String)"Contains key StringThree");
        Assert.assertFalse((boolean)map.containsValue(VALUE_1), (String)("Contains value " + VALUE_1));
        Assert.assertTrue((boolean)map.containsValue(VALUE_2), (String)("Contains value " + VALUE_2));
        Assert.assertNull((Object)map.put(KEY_2, VALUE_1), (String)"Initial result of put should be null");
        Assert.assertEquals((int)map.size(), (int)2, (String)"Two element expected");
        Assert.assertTrue((boolean)map.containsKey(KEY_1), (String)"Contains key StringOne");
        Assert.assertTrue((boolean)map.containsKey(KEY_2), (String)"Contains key StringTwo");
        Assert.assertTrue((boolean)map.containsValue(VALUE_1), (String)("Contains value " + VALUE_1));
        Assert.assertTrue((boolean)map.containsValue(VALUE_2), (String)("Contains value " + VALUE_2));
        Assert.assertEquals((Object)map.put(KEY_2, VALUE_2), (Object)VALUE_1, (String)"Should have replaced");
        Assert.assertEquals((int)map.size(), (int)2, (String)"Two element expected");
        Assert.assertTrue((boolean)map.containsKey(KEY_1), (String)"Contains key StringOne");
        Assert.assertTrue((boolean)map.containsKey(KEY_2), (String)"Contains key StringTwo");
        Assert.assertFalse((boolean)map.containsKey(KEY_3), (String)"Contains key StringThree");
        Assert.assertFalse((boolean)map.containsValue(VALUE_1), (String)("Contains value " + VALUE_1));
        Assert.assertTrue((boolean)map.containsValue(VALUE_2), (String)("Contains value " + VALUE_2));
        Assert.assertEquals((int)map.values().size(), (int)2, (String)"Two Keys, one value");
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(map.values());
        Assert.assertEquals((int)set.size(), (int)1, (String)"Two Keys, one (distinct) value");
        Assert.assertEquals((int)map.keySet().size(), (int)2, (String)"Two Keys, one value");
        Assert.assertEquals((int)map.entrySet().size(), (int)2, (String)"Two Keys, one value");
        Assert.assertEquals((Object)map.put(KEY_2, VALUE_3), (Object)VALUE_2, (String)"Should have replaced");
        Assert.assertEquals((Object)map.put(KEY_1, VALUE_3), (Object)VALUE_2, (String)"Should have replaced");
        Assert.assertTrue((boolean)map.containsValue(INTEGER_3), (String)("Contains value " + INTEGER_3));
        HashMap<String, Integer> testMap = new HashMap<String, Integer>();
        testMap.put(KEY_1, INTEGER_3);
        testMap.put(KEY_2, INTEGER_3);
        Assert.assertTrue((boolean)testMap.equals(map), (String)"test against type changes");
        map.putAll(testMap);
        Assert.assertEquals((int)map.size(), (int)2, (String)"Two element expected");
        map.clear();
        Assert.assertEquals((int)map.size(), (int)0, (String)"After clear map must be empty");
        map.put(KEY_1, VALUE_1);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        Iterator<Map.Entry<String, Object>> entryIter = entrySet.iterator();
        entryIter.next();
        entryIter.remove();
        map.clear();
        Assert.assertEquals((int)map.size(), (int)0, (String)"After clear map must be empty");
        map.put(KEY_1, VALUE_1);
        Set<String> keySet = map.keySet();
        Iterator<String> keyIter = keySet.iterator();
        keyIter.next();
        keyIter.remove();
        map.clear();
        Assert.assertEquals((int)map.size(), (int)0, (String)"After clear map must be empty");
        map.put(KEY_1, VALUE_1);
        Collection<Object> values = map.values();
        Iterator<Object> valuesIter = values.iterator();
        valuesIter.next();
        valuesIter.remove();
    }

    @Test
    public void verfiyTest() {
        MapTest.testMap(new HashMap<String, Object>());
    }
}

