/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.security.impl;

import java.io.File;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import net.shibboleth.utilities.java.support.security.impl.ScriptedKeyStrategy;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ScriptedKeyStrategyTest {
    final String scriptPath = "src/test/resources/net/shibboleth/utilities/java/support/security/keyStrategyScript.js";
    private Map<String, Object> customMap;
    private KeyGenerator keyGenerator;
    private ScriptedKeyStrategy strategy;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException, NoSuchAlgorithmException, ScriptException {
        SecureRandom random = new SecureRandom();
        this.keyGenerator = KeyGenerator.getInstance("AES");
        this.keyGenerator.init(random);
        this.customMap = new HashMap<String, Object>();
        this.customMap.put("secret1", this.keyGenerator.generateKey());
        this.customMap.put("default", "secret1");
        this.strategy = new ScriptedKeyStrategy();
        this.strategy.setUpdateInterval(Duration.ofSeconds(1L));
        this.strategy.setKeyScript(new EvaluableScript("javascript", new File("src/test/resources/net/shibboleth/utilities/java/support/security/keyStrategyScript.js")));
        this.strategy.setCustomObject(this.customMap);
        this.strategy.setCacheSize(1L);
        this.strategy.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoScript() throws ComponentInitializationException {
        new ScriptedKeyStrategy().initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testScriptFailure() throws ComponentInitializationException, ScriptException {
        ScriptedKeyStrategy estrategy = new ScriptedKeyStrategy();
        estrategy.setKeyScript(new EvaluableScript("null"));
        estrategy.initialize();
    }

    @Test
    public void testScriptedKeystoreKeyStrategy() throws Exception {
        Assert.assertEquals((String)((String)this.strategy.getDefaultKey().getFirst()), (String)"secret1");
        try {
            this.strategy.getKey("secret2");
            Assert.fail((String)"secret2 should not exist");
        }
        catch (KeyException keyException) {
            // empty catch block
        }
        this.customMap.put("secret2", this.keyGenerator.generateKey());
        this.customMap.put("default", "secret2");
        Thread.sleep(5000L);
        Assert.assertEquals((String)((String)this.strategy.getDefaultKey().getFirst()), (String)"secret2");
        Assert.assertNotNull((Object)this.strategy.getKey("secret1"));
        this.customMap.put("secret3", this.keyGenerator.generateKey());
        this.customMap.put("default", "secret3");
        this.customMap.remove("secret1");
        Thread.sleep(5000L);
        Assert.assertEquals((String)((String)this.strategy.getDefaultKey().getFirst()), (String)"secret3");
        Assert.assertNotNull((Object)this.strategy.getKey("secret2"));
        try {
            this.strategy.getKey("secret1");
            Assert.fail((String)"secret1 should not exist");
        }
        catch (KeyException keyException) {
            // empty catch block
        }
    }
}

