/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import net.shibboleth.utilities.java.support.collection.IndexingObjectStore;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IndexingObjectStoreTest {
    @Test
    public void testIndexingObjectStore() {
        IndexingObjectStore store = new IndexingObjectStore();
        String str1 = new String("foo");
        String str2 = new String("bar");
        Assert.assertTrue((boolean)store.isEmpty());
        Assert.assertEquals((int)store.size(), (int)0);
        Assert.assertFalse((boolean)store.containsInstance((Object)"foo"));
        String nullIndex = store.put(null);
        Assert.assertNull((Object)nullIndex);
        Assert.assertTrue((boolean)store.isEmpty());
        Assert.assertEquals((int)store.size(), (int)0);
        Assert.assertFalse((boolean)store.containsInstance(null));
        String str1Index = store.put((Object)str1);
        Assert.assertTrue((boolean)store.containsIndex(str1Index));
        Assert.assertTrue((boolean)store.containsInstance((Object)"foo"));
        Assert.assertFalse((boolean)store.isEmpty());
        Assert.assertEquals((int)store.size(), (int)1);
        Assert.assertEquals((String)((String)store.get(str1Index)), (String)str1);
        String index1 = store.put((Object)"foo");
        Assert.assertTrue((boolean)store.containsIndex(index1));
        Assert.assertTrue((boolean)store.containsInstance((Object)"foo"));
        Assert.assertFalse((boolean)store.isEmpty());
        Assert.assertEquals((int)store.size(), (int)1);
        Assert.assertEquals((String)index1, (String)str1Index);
        Assert.assertEquals((String)((String)store.get(index1)), (String)str1);
        store.remove(str1Index);
        Assert.assertTrue((boolean)store.containsIndex(index1));
        Assert.assertTrue((boolean)store.containsInstance((Object)"foo"));
        Assert.assertFalse((boolean)store.isEmpty());
        Assert.assertEquals((int)store.size(), (int)1);
        Assert.assertEquals((String)index1, (String)index1);
        Assert.assertEquals((String)((String)store.get(index1)), (String)str1);
        String str2Index = store.put((Object)str2);
        Assert.assertTrue((boolean)store.containsIndex(str2Index));
        Assert.assertTrue((boolean)store.containsInstance((Object)"bar"));
        Assert.assertFalse((boolean)store.isEmpty());
        Assert.assertEquals((int)store.size(), (int)2);
        Assert.assertEquals((String)((String)store.get(str2Index)), (String)str2);
        store.remove(str1Index);
        Assert.assertFalse((boolean)store.containsIndex(str1Index));
        Assert.assertFalse((boolean)store.containsInstance((Object)"foo"));
        Assert.assertFalse((boolean)store.isEmpty());
        Assert.assertEquals((int)store.size(), (int)1);
        Assert.assertNull((Object)store.get(str1Index));
        store.clear();
        Assert.assertTrue((boolean)store.isEmpty());
        Assert.assertEquals((int)store.size(), (int)0);
        Assert.assertFalse((boolean)store.containsInstance((Object)"foo"));
        Assert.assertFalse((boolean)store.containsInstance((Object)"bar"));
    }

    @Test
    public void testCollision() {
        String s1 = "FB";
        String s2 = "Ea";
        Assert.assertEquals((int)"FB".hashCode(), (int)"Ea".hashCode());
        IndexingObjectStore store = new IndexingObjectStore();
        String s1index = store.put((Object)"FB");
        String s2index = store.put((Object)"Ea");
        Assert.assertNotEquals((Object)s1index, (Object)s2index);
        Assert.assertTrue((boolean)store.containsIndex(s1index));
        Assert.assertTrue((boolean)store.containsIndex(s2index));
        Assert.assertEquals((String)((String)store.get(s1index)), (String)"FB");
        Assert.assertEquals((String)((String)store.get(s2index)), (String)"Ea");
    }
}

