/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.util.Arrays;
import java.util.List;
import net.shibboleth.utilities.java.support.collection.ClassToInstanceMultiMap;
import net.shibboleth.utilities.java.support.collection.LockableClassToInstanceMultiMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LockableClassToInstanceMultiMapTest {
    @Test
    public void testClearIsEmpty() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap();
        map.clear();
        Assert.assertTrue((boolean)map.isEmptyWithLock());
        map.put(new Object());
        Assert.assertFalse((boolean)map.isEmptyWithLock());
        map.clear();
        Assert.assertTrue((boolean)map.isEmptyWithLock());
    }

    @Test
    public void testKeysAndContainsKey() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap();
        this.populate((ClassToInstanceMultiMap<Temporal>)map);
        Assert.assertEquals((int)map.keysWithLock().size(), (int)2);
        Assert.assertFalse((boolean)map.containsKeyWithLock(null));
        Assert.assertFalse((boolean)map.containsKeyWithLock(Chronology.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(Temporal.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(TemporalAdjuster.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(ZonedDateTime.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(ChronoZonedDateTime.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(Comparable.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(Serializable.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(Instant.class));
        map = new LockableClassToInstanceMultiMap(true);
        this.populate((ClassToInstanceMultiMap<Temporal>)map);
        Assert.assertEquals((int)map.keysWithLock().size(), (int)8);
        Assert.assertFalse((boolean)map.containsKeyWithLock(null));
        Assert.assertFalse((boolean)map.containsKeyWithLock(Chronology.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(Temporal.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(TemporalAdjuster.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(ZonedDateTime.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(ChronoZonedDateTime.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(Comparable.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(Serializable.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(Instant.class));
    }

    @Test
    public void testValuesAndContainsValues() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap();
        ZonedDateTime now = ZonedDateTime.now();
        map.put((Object)now);
        ZonedDateTime now100 = now.plusMinutes(100L);
        map.put((Object)now100);
        Instant instant = Instant.now();
        map.put((Object)instant);
        Assert.assertEquals((int)map.valuesWithLock().size(), (int)3);
        Assert.assertFalse((boolean)map.containsValueWithLock(null));
        Assert.assertFalse((boolean)map.containsValueWithLock((Object)now.minusMinutes(100L)));
        Assert.assertFalse((boolean)map.containsValueWithLock((Object)instant.minusSeconds(100L)));
        Assert.assertTrue((boolean)map.containsValueWithLock((Object)instant));
        Assert.assertTrue((boolean)map.containsValueWithLock((Object)now));
        Assert.assertTrue((boolean)map.containsValueWithLock((Object)now100));
    }

    @Test
    public void testEquals() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap();
        LockableClassToInstanceMultiMap map2 = new LockableClassToInstanceMultiMap();
        LockableClassToInstanceMultiMap map3 = new LockableClassToInstanceMultiMap();
        ZonedDateTime now = ZonedDateTime.now();
        map.putWithLock((Object)now);
        map2.putWithLock((Object)now);
        map3.putWithLock((Object)now);
        ZonedDateTime now100 = now.plusMinutes(100L);
        map.putWithLock((Object)now100);
        map2.putWithLock((Object)now100);
        map3.putWithLock((Object)now100);
        Instant instant = Instant.now();
        map.putWithLock((Object)instant);
        map2.putWithLock((Object)instant);
        Assert.assertTrue((boolean)map.equals((Object)map2));
        Assert.assertFalse((boolean)map.equals((Object)map3));
        Assert.assertEquals((int)map.hashCode(), (int)map2.hashCode());
        Assert.assertNotEquals((Object)map.hashCode(), (Object)map3.hashCode());
    }

    @Test
    public void testGet() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap();
        this.populate((ClassToInstanceMultiMap<Temporal>)map);
        List values = map.getWithLock(null);
        Assert.assertEquals((int)values.size(), (int)0);
        values = map.getWithLock(ZonedDateTime.class);
        Assert.assertEquals((int)values.size(), (int)2);
        values = map.getWithLock(Instant.class);
        Assert.assertEquals((int)values.size(), (int)1);
    }

    @Test
    public void testNoIndexedDuplicateValues() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap(true);
        map.putWithLock((Object)new FooBarImpl());
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(AbstractFoo.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(AbstractFooBar.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(FooBarImpl.class).size(), (int)1);
    }

    @Test
    public void testDuplicateInsertions() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap(true);
        FooBarImpl fb = new FooBarImpl();
        map.putWithLock((Object)fb);
        map.putWithLock((Object)fb);
        Assert.assertEquals((int)map.valuesWithLock().size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(AbstractFoo.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(AbstractFooBar.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(FooBarImpl.class).size(), (int)1);
    }

    @Test
    public void testRemoveValue() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap(true);
        FooBarImpl fb = new FooBarImpl();
        FooImpl f = new FooImpl();
        map.putWithLock((Object)fb);
        map.putWithLock((Object)f);
        Assert.assertTrue((boolean)map.containsValueWithLock((Object)fb));
        Assert.assertTrue((boolean)map.containsValueWithLock((Object)f));
        Assert.assertTrue((boolean)map.containsKeyWithLock(Foo.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(AbstractFoo.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(FooImpl.class));
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)2);
        Assert.assertEquals((int)map.getWithLock(AbstractFoo.class).size(), (int)2);
        Assert.assertEquals((int)map.getWithLock(FooImpl.class).size(), (int)1);
        Assert.assertTrue((boolean)map.containsKeyWithLock(Bar.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(AbstractFooBar.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(FooBarImpl.class));
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(AbstractFooBar.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(FooBarImpl.class).size(), (int)1);
        map.remove((Object)fb);
        Assert.assertFalse((boolean)map.containsValueWithLock((Object)fb));
        Assert.assertTrue((boolean)map.containsValueWithLock((Object)f));
        Assert.assertTrue((boolean)map.containsKeyWithLock(Foo.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(AbstractFoo.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(FooImpl.class));
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(AbstractFoo.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(FooImpl.class).size(), (int)1);
        Assert.assertFalse((boolean)map.containsKeyWithLock(Bar.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(AbstractFooBar.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(FooBarImpl.class));
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)0);
        Assert.assertEquals((int)map.getWithLock(AbstractFooBar.class).size(), (int)0);
        Assert.assertEquals((int)map.getWithLock(FooBarImpl.class).size(), (int)0);
    }

    @Test
    public void testRemoveByType() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap(true);
        FooBarImpl fb = new FooBarImpl();
        FooImpl f = new FooImpl();
        map.putWithLock((Object)fb);
        map.putWithLock((Object)f);
        Assert.assertTrue((boolean)map.containsValueWithLock((Object)fb));
        Assert.assertTrue((boolean)map.containsValueWithLock((Object)f));
        Assert.assertTrue((boolean)map.containsKeyWithLock(Foo.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(AbstractFoo.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(FooImpl.class));
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)2);
        Assert.assertEquals((int)map.getWithLock(AbstractFoo.class).size(), (int)2);
        Assert.assertEquals((int)map.getWithLock(FooImpl.class).size(), (int)1);
        Assert.assertTrue((boolean)map.containsKeyWithLock(Bar.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(AbstractFooBar.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(FooBarImpl.class));
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(AbstractFooBar.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(FooBarImpl.class).size(), (int)1);
        map.removeWithLock(Bar.class);
        Assert.assertFalse((boolean)map.containsValueWithLock((Object)fb));
        Assert.assertTrue((boolean)map.containsValueWithLock((Object)f));
        Assert.assertTrue((boolean)map.containsKeyWithLock(Foo.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(AbstractFoo.class));
        Assert.assertTrue((boolean)map.containsKeyWithLock(FooImpl.class));
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(AbstractFoo.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(FooImpl.class).size(), (int)1);
        Assert.assertFalse((boolean)map.containsKeyWithLock(Bar.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(AbstractFooBar.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(FooBarImpl.class));
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)0);
        Assert.assertEquals((int)map.getWithLock(AbstractFooBar.class).size(), (int)0);
        Assert.assertEquals((int)map.getWithLock(FooBarImpl.class).size(), (int)0);
    }

    @Test
    public void testRemoveAll() {
        LockableClassToInstanceMultiMap map = new LockableClassToInstanceMultiMap(true);
        FooImpl f1 = new FooImpl();
        FooImpl f2 = new FooImpl();
        FooImpl f3 = new FooImpl();
        FooBarImpl fb1 = new FooBarImpl();
        FooBarImpl fb2 = new FooBarImpl();
        FooBarImpl fb3 = new FooBarImpl();
        map.putWithLock((Object)f1);
        map.putWithLock((Object)f2);
        map.putWithLock((Object)f3);
        map.putWithLock((Object)fb1);
        map.putWithLock((Object)fb2);
        map.putWithLock((Object)fb3);
        Assert.assertEquals((int)map.valuesWithLock().size(), (int)6);
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)6);
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)3);
        map.removeAllWithLock(Arrays.asList(f1, f2, fb1));
        Assert.assertEquals((int)map.valuesWithLock().size(), (int)3);
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)3);
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)2);
        map.removeAllWithLock(Arrays.asList(fb2, fb3));
        Assert.assertEquals((int)map.valuesWithLock().size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)0);
        Assert.assertFalse((boolean)map.containsKeyWithLock(Bar.class));
        map.removeAllWithLock(Arrays.asList(f3));
        Assert.assertEquals((int)map.valuesWithLock().size(), (int)0);
        Assert.assertTrue((boolean)map.isEmptyWithLock());
        Assert.assertEquals((int)map.getWithLock(Foo.class).size(), (int)0);
        Assert.assertEquals((int)map.getWithLock(Bar.class).size(), (int)0);
        Assert.assertFalse((boolean)map.containsKeyWithLock(Foo.class));
        Assert.assertFalse((boolean)map.containsKeyWithLock(Bar.class));
    }

    protected void populate(ClassToInstanceMultiMap<Temporal> map) {
        ZonedDateTime now = ZonedDateTime.now();
        map.put((Object)now);
        ZonedDateTime now100 = now.plusMinutes(100L);
        map.put((Object)now100);
        Instant instant = Instant.now();
        map.put((Object)instant);
    }

    public class FooBarImpl
    extends AbstractFooBar {
    }

    public abstract class AbstractFooBar
    extends AbstractFoo
    implements Bar {
    }

    public class FooImpl
    extends AbstractFoo {
    }

    public abstract class AbstractFoo
    implements Foo {
    }

    public static interface Bar
    extends Foo {
    }

    public static interface Foo {
    }
}

