/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.testing;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ShowAutomaticModuleNames {
    private static final String AUTO_MODULE_NAME = "Automatic-Module-Name";

    @Nullable
    private String getAutomaticModuleName(@Nonnull JarFile jarFile) throws TerminationException {
        try {
            Manifest manifest = jarFile.getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            return mainAttributes.getValue(AUTO_MODULE_NAME);
        }
        catch (IOException e) {
            throw new TerminationException("IOException while processing file", e);
        }
    }

    private void runDirectory(@Nonnull File directory) throws TerminationException {
        System.out.println("Processing directory: " + directory.getAbsolutePath());
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        HashMap<String, File> seenNames = new HashMap<String, File>();
        ArrayList<File> noName = new ArrayList<File>();
        HashMap<File, String> withName = new HashMap<File, String>();
        HashMap<File, Object> problemNames = new HashMap<File, Object>();
        for (File file : files) {
            try (JarFile jarFile = new JarFile(file);){
                String automaticName = this.getAutomaticModuleName(jarFile);
                if (automaticName == null) {
                    noName.add(file);
                    continue;
                }
                if (automaticName.isEmpty()) {
                    problemNames.put(file, "empty module name");
                    continue;
                }
                if (seenNames.containsKey(automaticName)) {
                    problemNames.put(file, "duplicate module name " + automaticName + " with " + ((File)seenNames.get(automaticName)).getName());
                    continue;
                }
                withName.put(file, automaticName);
                seenNames.put(automaticName, file);
            }
            catch (IOException e) {
                throw new TerminationException("could not process " + file.getName(), e);
            }
        }
        if (!problemNames.isEmpty()) {
            System.out.println("   *** with problematic names:");
            ArrayList problemFiles = new ArrayList(problemNames.keySet());
            for (File file : problemFiles) {
                System.out.println("      " + file.getName() + ": " + (String)problemNames.get(file));
            }
        }
        if (!withName.isEmpty()) {
            System.out.println("   with module names:");
            ArrayList withNameFiles = new ArrayList(withName.keySet());
            withNameFiles.sort(null);
            for (File file : withNameFiles) {
                System.out.println("      " + file.getName() + " --> " + (String)withName.get(file));
            }
        }
        if (!noName.isEmpty()) {
            System.out.println("   with no module name:");
            noName.sort(null);
            for (File file : noName) {
                System.out.println("      " + file.getName());
            }
        }
    }

    private void run(@Nonnull String[] args) throws TerminationException {
        if (args.length != 1) {
            throw new TerminationException("ShowAutomaticModuleNames requires one argument, a file or directory");
        }
        String fileName = args[0];
        File file = new File(fileName);
        if (!file.exists()) {
            throw new TerminationException(fileName + " does not exist");
        }
        if (file.isDirectory()) {
            this.runDirectory(file);
        } else {
            try (JarFile jarFile = new JarFile(file);){
                String automaticName = this.getAutomaticModuleName(jarFile);
                System.out.println("Automatic module name for " + fileName + " is " + automaticName);
            }
            catch (IOException e) {
                throw new TerminationException("could not process " + fileName, e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            new ShowAutomaticModuleNames().run(args);
        }
        catch (TerminationException e) {
            e.printStackTrace();
            System.err.println("*** ERROR: " + e.getMessage());
            System.exit(1);
        }
    }

    private static class TerminationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TerminationException(@Nonnull String message) {
            super(message);
        }

        public TerminationException(@Nonnull String message, @Nonnull Throwable cause) {
            super(message, cause);
        }
    }
}

