/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.parser.selector.SelectorList;
import com.gargoylesoftware.css.util.LangUtils;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;

public class CSSStyleRuleImpl
extends AbstractCSSRuleImpl
implements CSSStyleRule {
    private SelectorList selectors_;
    private CSSStyleDeclaration style_;

    public SelectorList getSelectors() {
        return this.selectors_;
    }

    public void setSelectors(SelectorList selectors) {
        this.selectors_ = selectors;
    }

    public CSSStyleRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, SelectorList selectors) {
        super(parentStyleSheet, parentRule);
        this.selectors_ = selectors;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public String getCssText() {
        CSSStyleDeclaration style = this.getStyle();
        if (null == style) {
            return "";
        }
        String selectorText = this.selectors_.toString();
        String styleText = style.toString();
        if (null == styleText || styleText.length() == 0) {
            return selectorText + " { }";
        }
        return selectorText + " { " + styleText + " }";
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheetImpl();
        if (parentStyleSheet != null && parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 1) {
                throw new DOMExceptionImpl(13, 3);
            }
            this.selectors_ = ((CSSStyleRuleImpl)r).selectors_;
            this.style_ = ((CSSStyleRuleImpl)r).style_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public String getSelectorText() {
        return this.selectors_.toString();
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheetImpl();
        if (parentStyleSheet != null && parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(selectorText));
            CSSOMParser parser = new CSSOMParser();
            this.selectors_ = parser.parseSelectors(is);
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclaration style) {
        this.style_ = style;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleRule)) {
            return false;
        }
        CSSStyleRule csr = (CSSStyleRule)obj;
        return super.equals(obj) && LangUtils.equals(this.getSelectorText(), csr.getSelectorText()) && LangUtils.equals(this.getStyle(), csr.getStyle());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.selectors_);
        hash = LangUtils.hashCode(hash, this.style_);
        return hash;
    }
}

