/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.util.LangUtils;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSUnknownRule;

public class CSSUnknownRuleImpl
extends AbstractCSSRuleImpl
implements CSSUnknownRule {
    private String text_;

    public CSSUnknownRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, String text) {
        super(parentStyleSheet, parentRule);
        this.text_ = text;
    }

    @Override
    public short getType() {
        return 0;
    }

    @Override
    public String getCssText() {
        if (null == this.text_) {
            return "";
        }
        return this.text_;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheetImpl();
        if (parentStyleSheet != null && parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 0) {
                throw new DOMExceptionImpl(13, 7);
            }
            this.text_ = ((CSSUnknownRuleImpl)r).text_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSUnknownRule)) {
            return false;
        }
        CSSUnknownRule cur = (CSSUnknownRule)obj;
        return super.equals(obj) && LangUtils.equals(this.getCssText(), cur.getCssText());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.text_);
        return hash;
    }
}

