/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import org.apache.commons.lang3.StringUtils;

public class InvalidSlf4jMessageFormatRule
extends AbstractJavaRule {
    private static final Set<String> LOGGER_LEVELS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("trace", "debug", "info", "warn", "error")));
    private static final String LOGGER_CLASS = "org.slf4j.Logger";

    @Override
    public Object visit(ASTName node, Object data) {
        NameDeclaration nameDeclaration = node.getNameDeclaration();
        if (nameDeclaration == null || !(nameDeclaration instanceof VariableNameDeclaration)) {
            return super.visit(node, data);
        }
        Class<?> type = ((VariableNameDeclaration)nameDeclaration).getType();
        if (type == null || !type.getName().equals(LOGGER_CLASS)) {
            return super.visit(node, data);
        }
        ASTPrimaryExpression parentNode = (ASTPrimaryExpression)node.getFirstParentOfType(ASTPrimaryExpression.class);
        String method = ((ASTName)((ASTPrimaryPrefix)parentNode.getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstChildOfType(ASTName.class)).getImage().replace(nameDeclaration.getImage() + ".", "");
        if (!LOGGER_LEVELS.contains(method)) {
            return super.visit(node, data);
        }
        List argumentList = ((ASTArgumentList)((ASTPrimarySuffix)parentNode.getFirstChildOfType(ASTPrimarySuffix.class)).getFirstDescendantOfType(ASTArgumentList.class)).findChildrenOfType(ASTExpression.class);
        ArrayList<ASTPrimaryExpression> params = new ArrayList<ASTPrimaryExpression>(argumentList.size());
        for (ASTExpression astExpression : argumentList) {
            ASTPrimaryExpression primaryExpression = (ASTPrimaryExpression)astExpression.getFirstChildOfType(ASTPrimaryExpression.class);
            if (primaryExpression == null) continue;
            params.add(primaryExpression);
        }
        if (params.isEmpty()) {
            return super.visit(node, data);
        }
        ASTPrimaryExpression messageParam = (ASTPrimaryExpression)params.get(0);
        params.remove(0);
        int expectedArguments = this.expectedArguments(messageParam);
        if (expectedArguments == 0) {
            return super.visit(node, data);
        }
        if (params.size() > expectedArguments) {
            this.removeThrowableParam(params);
        }
        if (params.size() < expectedArguments) {
            this.addViolationWithMessage(data, node, "Missing arguments," + this.getExpectedMessage(params, expectedArguments));
        } else if (params.size() > expectedArguments) {
            this.addViolationWithMessage(data, node, "Too many arguments," + this.getExpectedMessage(params, expectedArguments));
        }
        return super.visit(node, data);
    }

    private boolean isNewThrowable(ASTPrimaryExpression last) {
        ASTClassOrInterfaceType classOrInterface = (ASTClassOrInterfaceType)last.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        return classOrInterface != null && classOrInterface.getType() != null && Throwable.class.isAssignableFrom(classOrInterface.getType());
    }

    private boolean hasTypeThrowable(ASTPrimaryExpression last) {
        return last.getType() != null && Throwable.class.isAssignableFrom(last.getType());
    }

    private boolean isReferencingThrowable(ASTPrimaryExpression last) {
        ASTName variable = (ASTName)last.getFirstDescendantOfType(ASTName.class);
        if (variable != null && variable.getNameDeclaration() != null && variable.getNameDeclaration() instanceof VariableNameDeclaration) {
            VariableNameDeclaration declaration = (VariableNameDeclaration)variable.getNameDeclaration();
            if (declaration.getType() != null && Throwable.class.isAssignableFrom(declaration.getType())) {
                return true;
            }
            if (declaration.getTypeImage() != null && declaration.getTypeImage().endsWith("Exception")) {
                return true;
            }
        }
        return false;
    }

    private void removeThrowableParam(List<ASTPrimaryExpression> params) {
        if (params.isEmpty()) {
            return;
        }
        int lastIndex = params.size() - 1;
        ASTPrimaryExpression last = params.get(lastIndex);
        if (this.isNewThrowable(last) || this.hasTypeThrowable(last) || this.isReferencingThrowable(last)) {
            params.remove(lastIndex);
            return;
        }
    }

    private String getExpectedMessage(List<ASTPrimaryExpression> params, int expectedArguments) {
        return " expected " + expectedArguments + (expectedArguments > 1 ? " arguments " : " argument ") + "but have " + params.size();
    }

    private int expectedArguments(ASTPrimaryExpression node) {
        List localValiables;
        String variableName;
        int count = 0;
        if (node.getFirstDescendantOfType(ASTLiteral.class) != null) {
            count = this.countPlaceholders(node);
        } else if (node.getFirstDescendantOfType(ASTName.class) != null && (count = this.getAmountOfExpectedArguments(variableName = ((ASTName)node.getFirstDescendantOfType(ASTName.class)).getImage(), localValiables = ((ASTMethodDeclaration)node.getFirstParentOfType(ASTMethodDeclaration.class)).findDescendantsOfType(ASTVariableDeclarator.class))) == 0) {
            List fieldlist = ((ASTClassOrInterfaceBody)node.getFirstParentOfType(ASTClassOrInterfaceBody.class)).findDescendantsOfType(ASTFieldDeclaration.class);
            ArrayList<ASTVariableDeclarator> fields = new ArrayList<ASTVariableDeclarator>(fieldlist.size());
            for (ASTFieldDeclaration astFieldDeclaration : fieldlist) {
                fields.add((ASTVariableDeclarator)astFieldDeclaration.getFirstChildOfType(ASTVariableDeclarator.class));
            }
            count = this.getAmountOfExpectedArguments(variableName, fields);
        }
        return count;
    }

    private int getAmountOfExpectedArguments(String variableName, List<ASTVariableDeclarator> variables) {
        for (ASTVariableDeclarator astVariableDeclarator : variables) {
            if (!((ASTVariableDeclaratorId)astVariableDeclarator.getFirstChildOfType(ASTVariableDeclaratorId.class)).getImage().equals(variableName)) continue;
            return this.countPlaceholders(astVariableDeclarator);
        }
        return 0;
    }

    private int countPlaceholders(AbstractJavaTypeNode node) {
        int result = 0;
        ASTLiteral stringLiteral = (ASTLiteral)node.getFirstDescendantOfType(ASTLiteral.class);
        if (stringLiteral != null) {
            result = StringUtils.countMatches((CharSequence)stringLiteral.getImage(), (CharSequence)"{}");
        }
        return result;
    }
}

