package order;

/**
 * @author Liang Wenxu
 * @since 2018/7/10
 */
public class Contants {
    /**
     * 商品类型{@value}: 实物商品
     */
    public static final String GOODS_TYPE_ENTITY = "1";

    /**
     * 商品类型{@value}: 虚拟商品
     */
    public static final String GOODS_TYPE_VIRTUAL = "2";

    /**
     * 订单模式{@value}: 常规订单
     */
    public static final String ORDER_MODE_NORMAL = "1";

    /**
     * 订单模式{@value}: 批量订单
     */
    public static final String ORDER_MODE_BATCH = "2";

    /**
     * 临时订单创建错误代码枚举
     */
    public enum TEMPORDER_CREATE_ERROR {
        // part1. 请求参数错误，错误代码从1001到1999
        // 未提供商品数据
        GOODS_NOT_PROVIDED("1001", "未提供商品数据"),
        //未知参数异常
        UN_DEFINITION_REQUEST_ERROR("1999", "未知参数异常"),
        // part2. 校验不通过，错误代码从2001到2999
        // 未提供商品数据
        INCLUED_NO_STOCK("2001", "订单中包含了无货商品"),
        AREA_CODE_ILLEGAL("2002", "下单地区areaCode不合法"),
        // part3. 业务错误，错误代码从3001到3999
        FALID_ON_QUERYING_FERIGHT("3001", "运费获取失败"),

        //未定义异常
        UNKNOW("9999", "未定义异常");

        /**
         * 自定义的枚举变量
         */
        private String name;
        /**
         * 自定义的枚举变量
         */
        private String value;

        TEMPORDER_CREATE_ERROR(String value, String name) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return name;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * 订单校验返回代码
     */
    public enum ORDER_PRECHECK_RESP_CODES {
        PASSED("0000", "所有校验通过"),
        NO_STOCK("0001", "部分商品无货，需在message段中标注无货商品"),
        SALES_PRICE_QUERY_ERROR("0002", "价格校验失败，获取销售价格出错"),
        SALES_PRICE_TOO_LOW("0003", "价格校验失败，以下商品销售价低于成本：[]"),

        //未定义异常
        UNKNOW("9999", "未定义异常");

        /**
         * 自定义的枚举变量
         */
        private String message;
        /**
         * 自定义的枚举变量
         */
        private String value;

        ORDER_PRECHECK_RESP_CODES(String value, String message) {
            this.message = message;
            this.value = value;
        }

        public String getMessage() {
            return message;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * 订单创建错误枚举
     */
    public enum ORDER_CREATE_ERROR {
        // part1. 请求参数错误，错误代码从1001到1999
        // 未提供子订单信息，在生成订单时未指定SubOrder时抛出
        SUBORDER_NOT_PROVIDED("1001", "请求中未包含下单的子订单信息"),
        // 未提供购买商品信息，SubOrder里没有item
        GOODS_NOT_PROVIDED("1002", "请求中未包含下单的商品信息"),
        //未知参数异常
        UN_DEFINITION_REQUEST_ERROR("1999", "未知参数异常"),
        // part2. 校验不通过，错误代码从2001到2999
        // 未提供商品数据
        INCLUED_NO_STOCK("2001", "订单中包含了无货商品"),
        AREA_CODE_ILLEGAL("2002", "下单地区areaCode不合法"),
        // part3. 业务错误，错误代码从3001到3999
        FAILD_ON_MARKETING_PROCESSING("3001", "营销活动处理失败"),
        FAILD_ON_STOCK_VALID("3002", "营销活动处理失败"),
        FAILD_ON_ORDER_PRECHECK("3003", "生成订单预校验失败"),
        FAILD_ON_ORDER_FREIGHT("3004", "订单运费获取失败"),
        ORDER_PRICE_REFRESHED("3005", "订单价格已更新"),
        ORDER_SUPILER_TAKE_ORDER_ERROR("3006", "供应商下单失败"),
        ORDER_SUBSCRIBE_ERROR("3007", "订单预占库存失败"),
        //未定义异常
        UNKNOW("9999", "未定义异常");

        /**
         * 自定义的枚举变量
         */
        private String message;
        /**
         * 自定义的枚举变量
         */
        private String value;

        ORDER_CREATE_ERROR(String value, String message) {
            this.message = message;
            this.value = value;
        }

        public String getMessage() {
            return message;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * 订单取消错误枚举
     */
    public enum ORDER_CANCEL_ERROR {
        // 订单key对应数据不存在，在订单取消时，更新影响数据为0条或查找不到对应订单时返回
        ORDER_NOFOUND("0001", "订单key对应数据不存在"),
        // 在数据库操作抛出异常时返回
        ORDER_SQL_EXCEPTION("0002", "订单取消数据持久化错误"),
        //未定义异常
        UNKNOW("9999", "未定义异常");

        /**
         * 自定义的枚举变量
         */
        private String message;
        /**
         * 自定义的枚举变量
         */
        private String value;

        ORDER_CANCEL_ERROR(String value, String message) {
            this.message = message;
            this.value = value;
        }

        public String getMessage() {
            return message;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * 订单取消类型枚举
     */
    public enum CancelOrderType {
        USER, // 客户主动取消订单
        ERROR, // 处理出错系统取消订单
        OVERTIMED, // 等待付款超时系统取消订单
        OTHER // 其它原因（预留）
    }

    /**
     * 临时订单创建错误代码枚举
     */
    public enum ORDER_AUDITING_ERROR {
        // part1. 请求参数错误，错误代码从1001到1999
        NOTAUDITABLE("1001", "非可审核订单"),
        ORDERMAIN_NOT_FOUND("1002", "对应订单获取失败"),
        SUPPLIER_TACK_ORDER_ERROR("1003", "第三方预占库存失败"),

        //未定义异常
        UNKNOW("9999", "未定义异常");

        /**
         * 自定义的枚举变量
         */
        private String message;
        /**
         * 自定义的枚举变量
         */
        private String value;

        ORDER_AUDITING_ERROR(String value, String message) {
            this.message = message;
            this.value = value;
        }

        public String getMessage() {
            return message;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * 错误代码枚举
     */
    public enum ORDER_PAY_CONFIRM_ERROR {
        /**
         * 供应商处理异常，从1001到1999
         */
        SUPPLIER_INTERFACE_ERROR("1001", "供应商接口调用异常"),
        ALREADY_COMFIRMED_ORDER("3101", "该订单已被确认下单，无需重复确认"),
        /**
         * 供应商账户异常，常见于苏宁的预付款额度不足或京东的账号余额不足
         */
        ACCOUNT_BALANCE_ERROR("3102", "供应商账户余额不足"),
        ORDER_CANCELED("3103", "订单已被供应商取消"),
        SUPPLIER_COMFIRMED_ERROR("9999", "供应商未定义错误");
        private String value;
        private String message;
        ORDER_PAY_CONFIRM_ERROR(String value) {
            this.value = value;
            this.message = value;
        }
        ORDER_PAY_CONFIRM_ERROR(String value, String message) {
            this.value = value;
            this.message = message;
        }
        public String getValue() {
            return this.value;
        }
        public String getMessage() {
            return this.message;
        }
        @Override
        public String toString() {
            return value;
        }
    }

    /**
     * 默认订单操作人：系统操作
     */
    public static String ORDER_OPERATOR_SYSTEM="system";

    /**
     * 订单收货类型：客户主动确认收货
     */
    public static String ORDER_RECEIPT_TYPE_CUSTOMER="custom";
    /**
     * 订单收货类型：供应商确认收货
     */
    public static String ORDER_RECEIPT_TYPE_SUPPLIER="supplier";
    /**
     * 订单收货类型：系统自动确认收货
     */
    public static String ORDER_RECEIPT_TYPE_SYSTEM="system";

    /**
     * 订单操作者代码：系统
     */
    public static final String ORDER_LOG_OPERATOR_SYSTEM = "system";

    /**
     * 订单操作者代码：用户操作
     */
    public static final String ORDER_LOG_OPERATOR_USER = "user";


    /**
     * 操作类型代码{@value}: 订单创建
     */
    public static final String ORDER_LOG_OPERATE_TYPE_CREATE = "create";
    /**
     * 操作类型代码{@value}: 状态变更
     */
    public static final String ORDER_LOG_OPERATE_TYPE_STATUS_CHANGE = "status";
    /**
     * 操作类型代码{@value}: 订单删除
     */
    public static final String ORDER_LOG_OPERATE_TYPE_DELETE = "delete";

}
