package order.api;

import order.vo.*;

/**
 * 订单操作Api接口，主要定义订单相关操作的业务接口
 * <p><b>Notic:</b>注意！不要定义save、saveAll之类的方法！
 * 此接口定义的方法必须面向准确业务！</p>
 * @author Liang Wenxu
 * @since 2018/7/11
 */
public interface BatchOrderApi {
    /**
     * 创建临时订单
     * <p>此接口传入所需购买的所有商品</p>
     * @param tempOrderCreateRequest 只传入客户勾选后的待购商品
     * @return 临时订单实例，如是批量下单、提交的商品中包含不同店铺等需生成多个订单的场景则临时订单会有父子订单，注意与商城展示用的临时订单Vo区分噢
     */
    TempOrderVo newTempOrder(TempOrderCreateRequest tempOrderCreateRequest);

    /**
     * 提交订单，将临时订单提交为真实订单并预占商品库存（如需要）
     * <p>在结算确认页面，用户确认操作后调用，将临时订单确认为真实订单</p>
     * @param tempOrder 临时订单
     * @return 返回OrderVo中将包括订单的简略信息，如需详情请调用OrderQueryApi中相关API进行查询
     */
    OrderVo submit(TempOrderVo tempOrder);
}
