package order.api;

import order.dto.MallParentOrderDto;
import order.dto.MallParentSubOrderNosDto;
import order.dto.SimpleParentOrderDto;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
public interface MallParentOrderApi {
    /**
     * 批量下单保存父订单
     *
     * @param mallParentOrderDto
     * @return
     */
    MallParentOrderDto saveMallParentOrder(MallParentOrderDto mallParentOrderDto);


    /**
     * 更改父订单状态
     * @param status
     * @param parentOrderId
     */
    int changeStatus(String status, String parentOrderId);

    /**
     * 获取商城子订单号列表
     *
     * @param parentOrderNo
     * @return
     */
    public MallParentSubOrderNosDto getMallSubOrderNos(String parentOrderNo);

    /**
     * 获取父订单信息
     *
     * @param parentOrderNo
     * @return
     */
    public BaseResponse<SimpleParentOrderDto> getSimpleParentOrderDto(String parentOrderNo);
}
