package order.api;

import order.dto.MallTempOrderDto;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/9
 * 商城订单API
 */
public interface MallTempOrderApi {
    /**
     * 批量下单保存临时订单
     * @param mallTempOrderDto
     * @return
     */
    BaseResponse saveMallTempOrder(MallTempOrderDto mallTempOrderDto);

    /**
     * 批量删除临时订单
     * @param ids
     * @return
     */
    BaseResponse deleteMallTempOrder(List<String> ids);

    /**
     * 根据memberId删除临时订单
     * @param memberId
     * @return
     */
    BaseResponse deleteMallTempOrder(String memberId);

    BaseResponse updateTempOrder(String errorInfo, String addressId, String memberId);
}
