package order.api;

import order.dto.OrderTemplateAdapterConfig;
import order.vo.OrderTemplateConfigKey;
import order.vo.query.OrderTemplateAdapterConfigQuery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 订单操作模型配置管理API
 * @author Liang Wenxu
 * @since 2018/7/20
 */
public interface OrderTemplateConfigManageApi {
    /**
     * 查询配置
     * @param queryRequest 查询条件
     * @return
     */
    List<OrderTemplateAdapterConfig> query(OrderTemplateAdapterConfigQuery queryRequest);

    /**
     * 查询配置（分页）
     * @param queryRequest 查询条件
     * @param pageable 分页对象
     * @return
     */
    Page<OrderTemplateAdapterConfig> query(OrderTemplateAdapterConfigQuery queryRequest, Pageable pageable);

    /**
     * 新增配置
     * @param newConfig
     */
    void create(OrderTemplateAdapterConfig newConfig);

    /**
     * 修改配置
     * @param modifyRequest
     * @return
     */
    OrderTemplateAdapterConfig modify(OrderTemplateAdapterConfig modifyRequest);

    /**
     * 启用配置
     * @param key 配置标识
     */
    void enable(OrderTemplateConfigKey key);

    /**
     * 禁用配置
     * @param key 配置标识
     */
    void disable(OrderTemplateConfigKey key);

    /**
     * 删除配置
     * @param key 配置标识
     */
    void delete(OrderTemplateConfigKey key);
}
