package order.api.query;

import order.dto.MallParentOrderDto;
import order.dto.MallParentSubOrderNosDto;
import order.dto.SimpleParentOrderDto;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
public interface MallParentOrderQueryApi {
    /**
     * 查询所有父订单
     *
     * @return
     */
    BaseResponse<List<MallParentOrderDto>> findAllMallParentOrder();

    /**
     * 获取商城子订单号列表
     *
     * @param parentOrderNo
     * @return
     */
    public MallParentSubOrderNosDto getMallSubOrderNos(String parentOrderNo);

    /**
     * 获取父订单信息
     *
     * @param parentOrderNo
     * @return
     */
    public BaseResponse<SimpleParentOrderDto> getSimpleParentOrderDto(String parentOrderNo);

    MallParentOrderDto findByOrderNo(String orderNo);

    /**
     * 根据id查询父订单
     *
     * @param parentOrderId
     * @return
     */
    MallParentOrderDto findParentOrderById(String parentOrderId);

    /**
     * 获取商城父订单号
     *
     * @param id
     * @return
     */
    public BaseResponse<String> findParentOrderNo(String id);



}
