package order.dto;

import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;

/**
 * 订单操作模型适配器配置表
 *
 * @author Liang Wenxu
 * @since 2018/7/9
 */
@Data
public class OrderTemplateAdapterConfig extends BaseDomainDto implements Serializable {

    private String id;

    /**
     * 订单模式（常规下单（单个订单）、批量下单等）
     */
    public String orderMode;

    /**
     * 商品类型
     */
    public String goodsType;

    /**
     * 渠道代码
     */
    public String orgCode;

    /**
     * 订单处理模板类名（全称，包括包名）
     */
    public String templateClass;

    /**
     * 订单处理模板名（用作处理模板类的BeanName）
     */
    public String templateName;

    /**
     * 是否启用
     */
    public Boolean enabled;

    /**
     * 备注
     */
    public String remarks;
}