package order.exceptions;

/**
 * 产品无库存一场
 */
public class NoStockException extends Exception {

    public NoStockException(String prodcutCode, String areaCode) {
        this.prodcutCode = prodcutCode;
        this.areaCode = areaCode;
    }

    public NoStockException(String message, String prodcutCode, String areaCode) {
        super(message);
        this.prodcutCode = prodcutCode;
        this.areaCode = areaCode;
    }

    public NoStockException(String message, Throwable cause, String prodcutCode, String areaCode) {
        super(message, cause);
        this.prodcutCode = prodcutCode;
        this.areaCode = areaCode;
    }

    public NoStockException(Throwable cause, String prodcutCode, String areaCode) {
        super(cause);
        this.prodcutCode = prodcutCode;
        this.areaCode = areaCode;
    }

    public NoStockException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, String prodcutCode, String areaCode) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.prodcutCode = prodcutCode;
        this.areaCode = areaCode;
    }

    private String prodcutCode;

    private String areaCode;

    public String getProdcutCode() {
        return prodcutCode;
    }

    public String getAreaCode() {
        return areaCode;
    }
}
