package order.exceptions;

import order.Contants;
import order.vo.TempOrderVo;

import java.security.PrivilegedActionException;
import java.util.List;

/**
 * 订单创建异常，在订单创建流程中错误的异常
 * @author Liang Wenxu
 * @since 2018/8/3
 */
public class OrderCreateException extends Exception {
    private static final long serialVersionUID = 6933154403454784497L;
    /**
     * 错误代码
     */
    private Contants.ORDER_CREATE_ERROR code;
    private TempOrderVo data;

    public OrderCreateException(String message) {
        super(message);
    }


    public OrderCreateException(Contants.ORDER_CREATE_ERROR code) {
        super(code.getMessage());
        this.code = code;
    }

    /**
     * Constructs a new exception with the specified detail message.  The
     * cause is not initialized, and may subsequently be initialized by
     * a call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public OrderCreateException(String message, Contants.ORDER_CREATE_ERROR code) {
        super(message);
        this.code = code;
    }

    /**
     * Constructs a new exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public OrderCreateException(String message, Contants.ORDER_CREATE_ERROR code, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    /**
     * Constructs a new exception with the specified cause and a detail
     * message of <tt>(cause==null ? null : cause.toString())</tt> (which
     * typically contains the class and detail message of <tt>cause</tt>).
     * This constructor is useful for exceptions that are little more than
     * wrappers for other throwables (for example, {@link
     * PrivilegedActionException}).
     *
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method).  (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @since 1.4
     */
    public OrderCreateException(Contants.ORDER_CREATE_ERROR code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    /**
     * Constructs a new exception with the specified detail message,
     * cause, suppression enabled or disabled, and writable stack
     * trace enabled or disabled.
     *
     * @param message            the detail message.
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @since 1.7
     */
    public OrderCreateException(String message, Contants.ORDER_CREATE_ERROR code, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.code = code;
    }


    public void setData(TempOrderVo data) {
        this.data = data;
    }
}
