package order.exceptions.temporder;

import order.Contants;

/**
 * @author Liang Wenxu
 * @since 2018/7/18
 */
public class GoodsNotProvidedException extends TempOrderCreateException {
    public GoodsNotProvidedException() {
        super(Contants.TEMPORDER_CREATE_ERROR.GOODS_NOT_PROVIDED);
    }

    /**
     * Constructs a new runtime exception with {@code null} as its
     * detail message.  The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     *
     * @param code
     */
    public GoodsNotProvidedException(Contants.TEMPORDER_CREATE_ERROR code) {
        super(code.getValue(), code);
    }

    /**
     * Constructs a new runtime exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     * @param code
     */
    public GoodsNotProvidedException(String message, Contants.TEMPORDER_CREATE_ERROR code) {
        super(message, code);
    }

    /**
     * Constructs a new runtime exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @param code
     * @since 1.4
     */
    public GoodsNotProvidedException(String message, Contants.TEMPORDER_CREATE_ERROR code, Throwable cause) {
        super(message, code, cause);
    }

    /**
     * Constructs a new runtime exception with the specified cause and a
     * detail message of <tt>(cause==null ? null : cause.toString())</tt>
     * (which typically contains the class and detail message of
     * <tt>cause</tt>).  This constructor is useful for runtime exceptions
     * that are little more than wrappers for other throwables.
     *
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method).  (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @param code
     * @since 1.4
     */
    public GoodsNotProvidedException(Contants.TEMPORDER_CREATE_ERROR code, Throwable cause) {
        super(code, cause);
    }

    /**
     * Constructs a new runtime exception with the specified detail
     * message, cause, suppression enabled or disabled, and writable
     * stack trace enabled or disabled.
     *
     * @param message            the detail message.
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @param code
     * @since 1.7
     */
    public GoodsNotProvidedException(String message, boolean enableSuppression, Contants.TEMPORDER_CREATE_ERROR code, Throwable cause, boolean writableStackTrace) {
        super(message, code, enableSuppression, writableStackTrace, cause);
    }
}
