package order.exceptions.temporder;

import lombok.Data;
import order.Contants;

/**
 * @author Liang Wenxu
 * @since 2018/7/18
 */
@Data
public class TempOrderCreateException extends Exception {
    /**
     * 错误代码
     */
    private Contants.TEMPORDER_CREATE_ERROR code;

    /**
     * Constructs a new runtime exception with {@code null} as its
     * detail message.  The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     */
    public TempOrderCreateException(Contants.TEMPORDER_CREATE_ERROR code) {
        super(code.getName());
        this.code = code;
    }

    /**
     * Constructs a new runtime exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public TempOrderCreateException(String message, Contants.TEMPORDER_CREATE_ERROR code) {
        super(message);
        this.code = code;
    }

    /**
     * Constructs a new runtime exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public TempOrderCreateException(String message, Contants.TEMPORDER_CREATE_ERROR code, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    /**
     * Constructs a new runtime exception with the specified cause and a
     * detail message of <tt>(cause==null ? null : cause.toString())</tt>
     * (which typically contains the class and detail message of
     * <tt>cause</tt>).  This constructor is useful for runtime exceptions
     * that are little more than wrappers for other throwables.
     *
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method).  (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @since 1.4
     */
    public TempOrderCreateException(Contants.TEMPORDER_CREATE_ERROR code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    /**
     * Constructs a new runtime exception with the specified detail
     * message, cause, suppression enabled or disabled, and writable
     * stack trace enabled or disabled.
     *
     * @param message            the detail message.
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @since 1.7
     */
    public TempOrderCreateException(String message, Contants.TEMPORDER_CREATE_ERROR code, boolean enableSuppression, boolean writableStackTrace, Throwable cause) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.code = code;
    }
}
