package order.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/7/12
 */
@Data
public class BuyerCartItem implements Serializable {

    /**
     * 店铺的ID
     */
    private String storeId;

    /**
     * 产品规格ID
     */
    private String productFashionId;

    /**
     * 产品类型：商品、赠品、配件等，定义见GlobalContants.PRODUCT_TYPE_开头的常量
     */
    private String productType;

    /**
     * 商品性质：实物商品、虚拟商品等，定义见{@link order.Contants}中GOODS_TYPE_开头常量
     */
    public String goodsType;

    /**
     * 购物数量
     */
    private Integer count;

    /**
     * 关联的子商品
     */
    private List<BuyerCartItem> children;
}
