package order.vo;

import lombok.Data;

import java.io.Serializable;

/**
 * 购买人的发票信息
 * @author Liang Wenxu
 * @since 2018/7/12
 */
@Data
public class BuyerInvoiceInfo implements Serializable {
    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 纳税人识别号
     */
    private String taxIdentification;

    /**
     * 开票机构
     */
    private String invoiceOrganization;

    /**
     * 发票收件人
     */
    private String consigneeName;

    /**
     * 发票收件人电话
     */
    private String consigneePhone;
    /**
     * 发票收件人省
     */
    private String consigneeProvinceCode;

    /**
     * 发票收件人市
     */
    private String consigneeCityCode;

    /**
     * 发票地址全地址
     */
    private String invoiceAddress;

    /**
     * 发票会员地址表id
     */
    private String invoiceAddressId;

    /**
     * 发票会员地址表编号
     */
    private String invoiceAddressNo;

    /**
     * 发票地址是否同收件地址
     */
    private Integer consigneeFlag;

    /**
     * 发票机构id
     */
    private String companyId;
}
