package order.vo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/8/3
 */
@Data
public class CreateOrderRequest implements Serializable {
    /**
     * 请求ID
     */
    private String requestId;
    /**
     * 临时订单号
     */
    private String tmpOrderNo;

    /**
     * 创建时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 子订单
     */
    TempSubOrderVo subOrder;

    /**
     * 订单礼品
     */
    private List<TmpOrderGiftVo> tmpOrderGifts;

    /**
     * 订单扩展属性
     */
    private List<OrderAttrVo> orderAttrs;

    /**
     * 订单使用的优惠券
     */
    private List<OrderCouponVo> orderCouponVos;

    /**
     * 判断是否使用积分兑换 1是  0否
     */
    private String useScore;

    /**
     * 订单用途代码
     */
    private String usageCode;

    /**
     * 下单地区
     */
    private String areaCode;

    /**
     * 地区代码序列，下标0为省，下标4为街道/乡镇
     */
    private List<String> areaCodeList;

    /**
     * 一个临时订单对应多个发票
     */
    private List<TempInvoiceVo> tempInvoiceVos;

    /**
     * 积分抵扣金额
     */
    private BigDecimal socrePrice;

    /**
     * 来源渠道代码
     */
    private String organizationCode;

    /**
     * 来源渠道表id
     */
    private String realOrganizationId;

    /**
     * 购买类型 ipad,mobile,pc
     */

    private String buyType;

    /**
     * 用来记录网页头信息
     */

    private String headMessage;

    /**
     * 浏览器类型
     */

    private String browserType;
    /**
     * 平台类型
     */

    private String platformType;

    /**
     * memberAddressId
     */
    private String memberAddrId;

    /**
     * 充值中心订单充值类型代码
     */
    private String rechargeTypeCode;

    /**
     * 积分兑换现金比值
     */
    private BigDecimal scoreExchangeMoneyRatio;

    /**
     * 订单积分抵扣金额限比
     */
    private BigDecimal orderUseScoreRatio;

    /**
     * 订单类型枚举
     */
    private String orderType;

    private String rechargePhone;

    /**
     * 购买人的会员ID
     */
    private String memberId;

    /**
     * 购买人的用户ID
     */
    private String userId;

    /**
     * 支付方式代码
     */
    private String paymentCode;
}
