package order.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 商品信息
 * @author Liang Wenxu
 * @since 2018/7/9
 */
@Data
public class GoodsInfoVo implements Serializable {
    /**
     * 店铺的ID
     */
    private String storeId;

    /**
     * 店铺代码
     */
    private String storeCode;

    /**
     * 店铺类型
     */
    private String storeType;

    /**
     * 产品规格ID
     */
    private String productFashionId;

    private String goodsId;

    /**
     * 产品类型：商品、赠品、配件等，定义见GlobalContants.PRODUCT_TYPE_开头的常量
     */
    private String productType;

    /**
     * 商品性质：实物商品、虚拟商品等，定义见{@link order.Contants}中GOODS_TYPE_开头常量
     */
    public String goodsType;

    /**
     * 购物数量
     */
    private Integer count;

    /**
     * 关联产品（配件、组合、赠品等）
     */
    List<GoodsInfoVo> children;
}
