package order.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/8/8
 */
@Data
public class OrderItemVo implements Serializable {
    /**
     * 产品类型{@value}: 商品
     */
    public static final String PRODUCT_TYPE_MERCHANDISE = "1";
    /**
     * 产品类型{@value}: 配件
     */
    public static final String PRODUCT_TYPE_FITTING = "2";
    /**
     * 产品类型{@value}: 赠品
     */
    public static final String PRODUCT_TYPE_GIFT = "3";

    protected String id;


    private String productId;
    private String goodsId;

    private String productName;    //包括规格
    private String productFashId;

    /**
     * 产品类型，详见Product中的PRODUCT_TYPE_开头
     */
    private String productType;

    /**
     * 产品图片（缩略图）
     */
    private String productPic;

    /**
     * 购买数量
     */
    private Integer count;

    private Integer returnCount;

    /**
     * 商品售价，对应最终的商品销售价格
     * 当存在主、配件组合时，此价格为主商品 + 配件的价格合计
     */
    private BigDecimal salePrice;

    /**
     * 原始商品售价，当存在主、配件组合时，此价格为主商品价格
     */
    private BigDecimal orginSalePrice;

    /**
     * 会员价
     */
    private BigDecimal memberPrice;

    /**
     * 商品成本价
     */
    private BigDecimal costPrice;

    /**
     * 商品最终售价
     */
    private BigDecimal finalPrice;

    /**
     * 秒杀价
     */
    private BigDecimal seckillPrice;

    /**
     * 产品价格
     */
    private BigDecimal productPrice;

    /**
     * 下单时商品销售价格浮动比例
     */
    private BigDecimal salePriceRate;

    private BigDecimal historyCostScore;
    /**
     * 是否已评价
     */
    private Boolean isDiscuss;
    //是否是活动商品
    private String activityId;
    /**
     * 是否已退货
     */
    private Boolean isRefund;

    /**
     * 预计送达时间（苏宁、）
     */
    private String arriveDate;

    /**
     * 供应商货物编码，如京东、苏宁的skuId
     */
    private String sku;

    /**
     * 第三方订单行号（苏宁、）
     */
    private String orderLineNumId;

    /**
     * 第三方套餐商品编号
     */
    private String packageNumber;

    /**
     * 下单时的第三方售价
     */
    private BigDecimal trdSalePrice;

    /**
     * 增加业务码 2018-5-30(竞价优化需求这里用作于需求编号，后期也可适用其他业务码)
     */
    private String businessCode;

    private String companyId;

    private List<OrderItemVo> children;

    /**
     * 商品价格小计（单价 * 数量）
     * @return
     */
    public BigDecimal getSumSalePrice() {
        if(this.getSalePrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getSalePrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 会员价小计（单价 * 数量）
     */
    public BigDecimal getSumMemberPrice() {
        if(this.getMemberPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getMemberPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 商品成本价小计（单价 * 数量）
     */
    public BigDecimal getSumCostPrice() {
        if(this.getCostPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getCostPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 商品最终售价小计（单价 * 数量）
     */
    public BigDecimal getSumFinalPrice() {
        if(this.getFinalPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getFinalPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 秒杀价小计（单价 * 数量）
     */
    public BigDecimal getSumSeckillPrice() {
        if(this.getSeckillPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getSeckillPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 产品价格小计（单价 * 数量）
     */
    public BigDecimal getSumProductPrice() {
        if(this.getProductPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getProductPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }
}
