package order.vo;

import java.io.Serializable;

/**
 * @author Liang Wenxu
 * @since 2018-01-31
 */
public class OrderJmsMessage implements Serializable {
    /**
     * 快速工厂，从订单DTO生成消息
     * @param orderMain
     * @param event
     * @return
     */
    public static OrderJmsMessage newMessage(OrderMainDto orderMain, OrderEvents event) {
        OrderJmsMessage orderJmsMessage = new OrderJmsMessage();
        orderJmsMessage.setEvent(event);
        orderJmsMessage.setOrderNo(orderMain.getOrderNo());
        orderJmsMessage.setOrderId(orderMain.getId());
        orderJmsMessage.setOrderStatus(orderMain.getStatus());
        orderJmsMessage.setOrgId(orderMain.getOrganizationId());
        orderJmsMessage.setStoreType(orderMain.getStoreType());
        return orderJmsMessage;
    }

    /**
     * 订单事件枚举
     * CREATED 订单创建
     * PASSED  订单审核通过
     * REDJECTED 订单审核打回
     * STATUS_CHANGED 订单状态改变
     */
    public enum OrderEvents {
        CREATED, PASSED, REDJECTED, STATUS_CHANGED
    }

    /**
     * 订单事件
     */
    private OrderEvents event;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 订单ID
     */
    private String orderId;
    /**
     * 店铺分类
     */
    private String storeType;
    /**
     * 店铺代码
     */
    private String storeCode;
    /**
     * 合作商ID
     */
    private String orgId;
    /**
     * 订单状态
     */
    private String orderStatus;

    public OrderEvents getEvent() {
        return event;
    }

    public void setEvent(OrderEvents event) {
        this.event = event;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getStoreType() {
        return storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    @Override
    public String toString() {
        return "OrderJmsMessage{" +
                "event=" + event +
                ", orderNo='" + orderNo + '\'' +
                ", orderId='" + orderId + '\'' +
                ", storeType='" + storeType + '\'' +
                ", storeCode='" + storeCode + '\'' +
                ", orgId='" + orgId + '\'' +
                ", orderStatus='" + orderStatus + '\'' +
                '}';
    }
}
